package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_systemtagdetail implements YosObject {
  @Override
  public String table_comment() {
    return "系统标签预设明细表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_systemtagdetailid", "系统标签预设明细表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new IntCol("sequence", "排序", "排序", true, false, false, 6));
    arrayList.add(new VarcharCol("helptips", "标签提示", "标签提示", 500, true, false, false, "", 3));
    arrayList.add(new BigIntCol("sys_systemtagid", "父级id", "父级id", false, false, false, 2));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, true, false, false, "", 1));
    arrayList.add(new VarcharCol("tag", "标签", "标签", 500, false, false, false, "", 4));
    arrayList.add(new SmallIntCol("issystem", "是否系统标签", "是否系统标签", false, false, false, 0, 5));
    return arrayList;
  }
}
