package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_systemmodule implements YosObject {
  @Override
  public String table_comment() {
    return "系统模块注册表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("systemmoduleid", "系统模块id");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new IntCol("sequence", "排序", "排序", true, false, false, 3));
    arrayList.add(new VarcharCol("systemmodule", "系统模块名称", "系统模块名称", 50, false, false, false, "", 2));
    arrayList.add(new BigIntCol("systemclientid", "操作端id", "操作端id", false, false, false, 0));
    arrayList.add(new VarcharCol("systemmodulename", "系统模块描述", "系统模块描述", 50, false, false, false, "", 3));
    arrayList.add(new VarcharCol("iconurl", "图标地址", "图标地址", 5000, true, false, false, "", 4));
    arrayList.add(new VarcharCol("iconurl_mainnav", "导航栏图标地址", "导航栏图标地址", 5000, true, false, false, "", 5));
    arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 6));
    return arrayList;
  }
}
