package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_systemapp_tablecols implements YosObject {
  @Override
  public String table_comment() {
    return "系统应用表格栏位设置表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("tablecolid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new IntCol("filter", "过滤方式", "0 不过滤，1 精确搜索，2 模糊搜索", false, false, false, 0, 3));
    arrayList.add(new IntCol("sequence", "排序号", "排序号", true, false, false, 0));
    arrayList.add(new SmallIntCol("hidden", "隐藏", "隐藏", false, false, false, 0, 3));
    arrayList.add(new IntCol("width", "宽度", "宽度", true, false, false, 0));
    arrayList.add(new BigIntCol("tableid", "表格id", "表格id", false, false, false, 0));
    arrayList.add(new SmallIntCol("sortable", "允许排序", "允许排序", true, false, false, 1));
    arrayList.add(new VarcharCol("title", "字段标题", "字段标题", 50, false, false, false, "", 0));
    arrayList.add(new VarcharCol("columnname", "字段名称", "字段名称", 50, false, false, false, "", 0));
    return arrayList;
  }
}
