package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_systemapp implements YosObject {
  @Override
  public String table_comment() {
    return "系统应用注册表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("systemappid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("systemmoduleid", "所属模块id", "所属模块id", false, false, false, 2));
    arrayList.add(new SmallIntCol("selectfileinattachment", "是否允许从媒体中心选择文件", "是否允许从媒体中心选择文件", true, false, false, 0, 7));
    arrayList.add(new IntCol("sequence", "默认排序", "默认排序", true, false, false, 14));
    arrayList.add(new VarcharCol("systemappname", "应用描述", "应用描述", 50, false, false, false, "", 11));
    arrayList.add(new SmallIntCol("isdatafollowup", "是否开启跟进动态管理", "是否开启跟进动态管理", false, false, false, 1, 4));
    arrayList.add(new VarcharCol("showplace", "显示位置", "显示位置（1:工作台、2:快捷区3:设置区）", 50, true, false, false, "1", 3));
    arrayList.add(new SmallIntCol("isneedauth", "需要授权", "需要授权", false, false, false, 1, 8));
    arrayList.add(new VarcharCol("iconurl", "图标地址", "图标地址", 5000, true, false, false, "", 12));
    arrayList.add(new SmallIntCol("isdatatag", "是否开启数据标签管理", "是否开启数据标签管理", false, false, false, 1, 5));
    arrayList.add(new VarcharCol("siteids", "站点", "站点", 200, false, false, false, "", 1));
    arrayList.add(new VarcharCol("apppath_index", "详情页路径", "详情页路径", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 9));
    arrayList.add(new VarcharCol("apppath", "路径", "路径", 500, true, false, false, "", 13));
    arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 15));
    arrayList.add(new VarcharCol("systemapp", "应用名称", "应用名称", 50, false, true, false, "", 10));
    arrayList.add(new SmallIntCol("isdatateam", "是否开启数据团队管理", "是否开启数据团队管理", false, false, false, 1, 6));
    return arrayList;
  }
}
