package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_site_parameter implements YosObject {
  @Override
  public String table_comment() {
    return "站点参数设置";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_site_parameterid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("bank_ccb_user_id", "建设银行银企直联操作员号", "建设银行银企直联操作员号", 50, true, false, false, "", 3));
    arrayList.add(new LongTextCol("projectcheckrule", "项目查重规则", "项目查重规则", false, false,"", 3));
    arrayList.add(new VarcharCol("bank_abc_channeltype", "农行银企直联渠道类型", "农行银企直联渠道类型", 50, true, false, false, "ERP", 3));
    arrayList.add(new VarcharCol("kuaidi100_key", "快递100KEY", "快递100KEY", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_boc_cusopr", "操作员代码", "中国银行企业操作员代码", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_ccb_cust_id", "建设银行银企直联客户号", "建设银行银企直联客户号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_abc_dbcur", "农行银企直联借方货币号", "农行银企直联借方货币号", 50, true, false, false, "01", 3));
    arrayList.add(new VarcharCol("mail_sendfrom", "发送人邮箱", "发送人邮箱", 50, true, false, false, "", 3));
    arrayList.add(new BigIntCol("salematerialfolderid", "营销物料文件夹ID", "营销物料文件夹ID", true, false, false, 4));
    arrayList.add(new VarcharCol("bank_abc_dbaccno", "农行银企直联借方账号", "农行银企直联借方账号", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("loginmode_phonenumber", "是否开启短信验证码登陆", "是否开启短信验证码登陆", false, false, false, 0, 13));
    arrayList.add(new VarcharCol("orderdefaultaccount", "订单类型默认账户设置", "订单类型默认账户设置", 500, true, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new SmallIntCol("password_needspecialchar", "密码是否需包含特殊字符", "密码是否需包含特殊字符", false, false, false, 0, 15));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 18));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 20));
    arrayList.add(new VarcharCol("mail_host", "邮箱服务器地址", "邮箱服务器地址", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("mail_transport_protocol", "邮件传输协议", "邮件传输协议", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_abc_host", "农行银企直连服务器地址", "农行银企直连服务器地址", 50, true, false, false, "localhost", 3));
    arrayList.add(new VarcharCol("nuonuo_invoice_token", "诺诺开票 Token", "诺诺开票 Token", 100, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("loginmode_account", "是否开启账号登陆", "是否开启账号登陆", false, false, false, 11));
    arrayList.add(new VarcharCol("nuonuo_invoice_appkey", "诺诺开票AppKey", "诺诺开票AppKey", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_boc_actacn", "中国银行账号", "中国银行账号", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("bank_abc_used", "农行银企直联开关", "农行银企直联开关", false, false, false, 0, 3));
    arrayList.add(new SmallIntCol("loginmode_wechat", "是否开启微信登陆", "是否开启微信登陆", false, false, false, 0, 12));
    arrayList.add(new LongTextCol("custcheckrule", "客户查重规则", "客户查重规则", false, false,"", 3));
    arrayList.add(new SmallIntCol("password_neednum", "密码是否需包含数字", "密码是否需包含数字", false, false, false, 0, 16));
    arrayList.add(new VarcharCol("nuonuo_invoice_appsecret", "诺诺开票AppSecret", "诺诺开票AppSecret", 50, true, false, false, "", 3));
    arrayList.add(new DecimalCol("order_rebate_userate", "订单返利使用默认比例", "订单返利使用默认比例", 16, 2, false, false, 0, 3));
    arrayList.add(new IntCol("order_paymentnode", "订单扣款节点", "订单扣款节点（1:订单提交、2:订单审核）", false, false, false, 1, 3));
    arrayList.add(new VarcharCol("bank_abc_port", "农行银企直连服务器监听端口", "农行银企直连服务器监听端口", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_ccb_accno", "建设银行客户账号", "建设银行客户账号", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("password_needcapital", "密码是否需要大写英文字母", "密码是否需要大写英文字母", false, false, false, 9));
    arrayList.add(new SmallIntCol("mail_smtp_auth", "邮件发送是否需要登陆认证", "邮件发送是否需要登陆认证", false, false, false, 1, 3));
    arrayList.add(new VarcharCol("bank_ccb_password", "建设银行银企直联密码", "建设银行银企直联密码", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("remind_showdialog", "弹框提醒", "弹框提醒", false, false, false, 1, 3));
    arrayList.add(new IntCol("password_length", "密码最短长度", "密码最短长度", false, false, false, 6, 14));
    arrayList.add(new VarcharCol("nuonuo_invoice_taxnum", "诺诺开票企业税号", "诺诺开票企业税号", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("dispatch_recheck", "发货单是否开启复核", "发货单是否开启复核", false, false, false, 1, 3));
    arrayList.add(new VarcharCol("workwechatsystemclient", "企业微信操作端", "企业微信操作端", 50, true, false, false, "", 1));
    arrayList.add(new VarcharCol("bank_ccb_port", "建设银行服务器监听端口", "建设银行服务器监听端口", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("nuonuo_invoice_salertel", "诺诺开票企业电话", "诺诺开票企业电话", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("password_default", "默认密码", "默认密码", 500, false, false, false, "", 17));
    arrayList.add(new LongTextCol("projectcheckfields", "项目报备规则", "项目报备字段完整性检测", true, false,"", 3));
    arrayList.add(new LongTextCol("orderdefaultrepeat", "允许重复添加商品的订单类型", "允许重复添加商品的订单类型", true, false,"", 3));
    arrayList.add(new IntCol("maxsmscount", "最大短信条数", "最大短信条数", true, false, false, 6));
    arrayList.add(new SmallIntCol("order_rebate_used", "订单返利使用开关", "订单返利使用开关", false, false, false, 0, 3));
    arrayList.add(new VarcharCol("bank_boc_termid", "中国银行企业前置机编号", "E开头+前置机IP地址（各段补零，无小数点12位）", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_abc_opno", "农行银企直连企业操作员编号", "农行银企直连企业操作员编号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_boc_ibknum", "中国银行联行号", "查询账号的联行号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 19));
    arrayList.add(new IntCol("projectprotectionperiod", "项目报备保护周期", "项目报备保护周期（月）", false, false, false, 0, 3));
    arrayList.add(new BigIntCol("appfolderid", "应用附件文件ID", "应用附件文件ID", true, false, false, 5));
    arrayList.add(new VarcharCol("bank_boc_custid", "中国银行客户编码", "企业在中行网银系统的客户编码", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_boc_url", "中国银行服务器地址", "中国银行服务器地址", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("kuaidi100_customer", "快递100公司编号", "快递100公司编号", 50, true, false, false, "", 3));
    arrayList.add(new IntCol("maxattinfodownloadflow", "最大下载流量（G）", "最大下载流量（G）", true, false, false, 7));
    arrayList.add(new VarcharCol("bank_ccb_host", "建设银行银企直联服务器地址", "建设银行银企直联服务器地址", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("nuonuo_invoice_saleraccount", "诺诺开票银行账号和开户行地址", "诺诺开票银行账号和开户行地址", 200, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("password_needlowercase", "密码是否需要小写英文字母", "密码是否需要小写英文字母", false, false, false, 10));
    arrayList.add(new SmallIntCol("nuonuo_invoice_used", "诺诺开票开启", "诺诺开票开启", false, false, false, 0, 3));
    arrayList.add(new VarcharCol("mail_password", "邮箱密码", "邮箱密码", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("mail_user", "邮箱账号", "邮箱账号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_abc_corpno", "农行银企直联客户号", "农行银企直联客户号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("bank_boc_trnid", "中国银行报文编号", "中国银行客户端产生的报文编号", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("bank_boc_used", "中国银行银企直联开关", "中国银行银企直联开关", false, false, false, 0, 3));
    arrayList.add(new SmallIntCol("bank_bbc_used", "建设银行银企直联开关", "建设银行银企直联开关", false, false, false, 0, 3));
    arrayList.add(new SmallIntCol("remind_sms", "短信提醒", "邮件发送", false, false, false, 0, 3));
    arrayList.add(new VarcharCol("bank_abc_dbprov", "农行银企直联借方省市代码", "农行银企直联借方省市代码", 50, true, false, false, "19", 3));
    arrayList.add(new IntCol("maxattinfovolume", "最大存储容量(G)", "最大存储容量(G)", true, false, false, 100, 8));
    arrayList.add(new VarcharCol("nuonuo_invoice_saleraddress", "诺诺开票企业地址", "诺诺开票企业地址", 100, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("remind_mail", "邮件发送", "邮件发送", false, false, false, 0, 2));
    return arrayList;
  }
}
