package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_site implements YosObject {
  @Override
  public String table_comment() {
    return "企业站点表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("siteuid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 1));
    arrayList.add(new SmallIntCol("magsite", "管理站点", "管理站点", true, false, false, 0, 1));
    arrayList.add(new VarcharCol("bucketname", "云桶名称", "云桶名称", 50, true, false, false, "", 4));
    arrayList.add(new VarcharCol("sitename", "站点名称", "站点名称，企业简称", 50, false, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点", 50, false, true, false, "", 1));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 1));
    arrayList.add(new VarcharCol("enterprisename", "企业名称", "企业名称", 200, true, false, false, "", 2));
    return arrayList;
  }
}
