package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_signin implements YosObject {
  @Override
  public String table_comment() {
    return "签到表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_signinid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("address", "详细地址", "详细地址", 500, true, false, false, "", 3));
    arrayList.add(new VarcharCol("city", "城市", "城市", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("latitude", "纬度", "纬度", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("county", "区县", "区县", 200, true, false, false, "", 3));
    arrayList.add(new DateTimeCol("signintime", "签到时间", "签到时间", true, false, "", 3));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 3));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", true, false, false, 3));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, true, false, false, "", 3));
    arrayList.add(new BigIntCol("userid", "用户id", "用户id", false, false, false, 3));
    arrayList.add(new DateCol("signindate", "签到日期", "签到日期", true, false, "", 3));
    arrayList.add(new VarcharCol("province", "省份", "省份", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("name", "姓名", "姓名", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new VarcharCol("position", "职位", "职位", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("depname", "部门名称", "部门名称", 50, true, false, false, "", 3));
    arrayList.add(new BigIntCol("sa_projectid", "工程项目表ID", "工程项目表ID", false, false, false, 3));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 3));
    arrayList.add(new VarcharCol("longitude", "经度", "经度", 50, true, false, false, "", 3));
    return arrayList;
  }
}
