package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_services implements YosObject {
  @Override
  public String table_comment() {
    return "系统自动任务注册表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("serviceid", "自动任务id");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("timelong", "最后一次执行耗时", "最后一次执行耗时", true, false, false, 7));
    arrayList.add(new VarcharCol("classname", "类路径", "类路径", 200, false, false, false, "", 1));
    arrayList.add(new DateTimeCol("lastruntime", "最后一次执行时间", "最后一次执行时间", true, false, "", 5));
    arrayList.add(new IntCol("successed", "最后一次执行结果", "最后一次执行结果", true, false, false, 6));
    arrayList.add(new IntCol("count", "间隔数", "间隔数", false, false, false, 1, 3));
    arrayList.add(new VarcharCol("time", "执行时间", "执行时间", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("type", "计划类型", "second,minute,hour,day", 50, false, false, false, "minute", 3));
    arrayList.add(new IntCol("intervaltime", "执行间隔（秒）", "执行间隔（秒）", true, false, false, 60, 2));
    arrayList.add(new VarcharCol("remarks", "备注", "备注", 500, true, false, false, "", 4));
    arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 3));
    return arrayList;
  }
}
