package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_role_datalimit implements YosObject {
  @Override
  public String table_comment() {
    return "用户角色数据权限";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_role_datalimitid", "用户角色数据限制ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 1003));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 1007));
    arrayList.add(new BigIntCol("roleid", "角色id", "角色id", false, false, false, 3));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 1008));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 1004));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 1009));
    arrayList.add(new TextCol("sqlstr", "sql语句", "sql语句", true, false, "", 3));
    arrayList.add(new VarcharCol("table_name", "表名称", "表名称", 30, false, false, false, "", 3));
    return arrayList;
  }
}
