package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_report_session implements YosObject {
  @Override
  public String table_comment() {
    return "报表访问校验";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_report_sessionid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("dataid", "dataid", "数据ID，打印传入响应的数据id，报表可不传或传0", false, false, false, 0, 3));
    arrayList.add(new BigIntCol("sys_reportid", "数据ID", "报表管理ID", false, false, false, 3));
    arrayList.add(new DateTimeCol("createdate", "请求时间", "请求时间", true, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("sessionid", "sessionid", "sessionid", 200, true, false, false, "", 3));
    arrayList.add(new VarcharCol("systemclient", "操作端名称", "操作端名称", 50, false, false, false, "", 3));
    arrayList.add(new BigIntCol("userid", "用户id", "用户id", false, false, false, 3));
    arrayList.add(new VarcharCol("token", "token", "token", 200, true, false, false, "", 3));
    return arrayList;
  }
}
