package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public final class sys_remind_configs implements YosObject {
    @Override
    public String table_comment() {
        return "系统提醒设置";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_remind_configsid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("remindmode", "提醒方式", "提醒方式 可多选", 50, false, false, false, "", 7));
        arrayList.add(new VarcharCol("remindtitle", "提醒标题", "提醒标题", 200, false, false, false, "", 6));
        arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 12));
        arrayList.add(new VarcharCol("wechatservice_systemclient", "微信公众号操作端", "微信公众号操作端", 50, true, false, false, "", 13));
        arrayList.add(new TextCol("sqlstr", "sql语句", "sql语句", true, false, "", 4));
        arrayList.add(new SmallIntCol("isuser", "账号提醒开关", "账号提醒开关", false, false, false, 0, 8));
        arrayList.add(new TextCol("content", "提醒内容", "提醒内容", false, false, "", 11));
        arrayList.add(new LongTextCol("systemappids", "跳转应用id", "跳转应用id", true, false, "", 1));
        arrayList.add(new LongTextCol("wechatservice_content", "微信公众号消息内容", "微信公众号消息内容", true, false, "", 3));
        arrayList.add(new VarcharCol("roleids", "角色ID数组", "角色ID数组", 50, true, false, false, "[]", 5));
        arrayList.add(new BigIntCol("sys_remind_configid", "数据ID", "系统提醒设置ID", false, false, false, 3));
        arrayList.add(new SmallIntCol("isrole", "角色提醒开关", "角色提醒开关", false, false, false, 0, 10));
        arrayList.add(new VarcharCol("userids", "账号ID数组", "账号ID数组", 50, true, false, false, "[]", 2));
        arrayList.add(new BigIntCol("systemappid", "跳转应用id", "跳转应用id", true, false, false, 1));
        arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 1));
        arrayList.add(new VarcharCol("issql", "(SQL)提醒开关", "(SQL)提醒开关", 50, false, false, false, "0", 9));
        return arrayList;
    }
}
