package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public final class sys_remind_config implements YosObject {
    @Override
    public String table_comment() {
        return "系统提醒设置";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_remind_configid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("remindmode", "默认提醒方式", "默认提醒方式可多选", 50, false, false, false, "", 8));
        arrayList.add(new VarcharCol("remindtitle", "默认提醒标题", "默认提醒标题", 200, false, false, false, "", 4));
        arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 9));
        arrayList.add(new VarcharCol("wechatservice_systemclient", "微信公众号操作端", "微信公众号操作端", 50, true, false, false, "", 11));
        arrayList.add(new TextCol("sqlstr", "默认sql语句", "默认sql语句", true, false, "", 1));
        arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, true, false, false, "", 7));
        arrayList.add(new TextCol("content", "默认提醒内容", "默认提醒内容", false, false, "", 5));
        arrayList.add(new LongTextCol("systemappids", "跳转应用id", "跳转应用id", true, false, "", 1));
        arrayList.add(new LongTextCol("wechatservice_content", "微信公众号消息内容", "微信公众号消息内容", true, false, "", 3));
        arrayList.add(new BigIntCol("systemappid", "跳转应用id", "跳转应用id", true, false, false, 1));
        arrayList.add(new VarcharCol("issql", "默认(SQL)提醒开关", "默认(SQL)提醒开关", 50, false, false, false, "0", 3));
        arrayList.add(new VarcharCol("remindname", "提醒名称", "提醒名称", 50, false, false, false, "", 6));
        arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 2));
        return arrayList;
    }
}
