package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_phonebook implements YosObject {
  @Override
  public String table_comment() {
    return "通讯录表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_phonebookid", "通讯录表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("sourcetable", "关联数据表", "关联数据表", 50, false, false, false, "", 16));
    arrayList.add(new BigIntCol("sourceid", "关联数据id", "关联数据id", false, false, false, 15));
    arrayList.add(new DateCol("birthday", "生日", "生日", true, false, "", 7));
    arrayList.add(new VarcharCol("sex", "性别", "性别", 10, true, false, false, "", 6));
    arrayList.add(new VarcharCol("homeaddress", "家庭地址", "家庭地址", 500, true, false, false, "", 9));
    arrayList.add(new VarcharCol("phonenumber", "手机号", "手机号", 50, true, false, false, "", 5));
    arrayList.add(new VarcharCol("telephone", "座机号、固定电话", "座机号、固定电话", 50, true, false, false, "", 3));
    arrayList.add(new BigIntCol("userid", "用户id", "用户id", false, false, false, 2));
    arrayList.add(new BigIntCol("sys_phonebookgroupid", "通讯录分组ID", "通讯录分组ID", false, false, false, 3));
    arrayList.add(new VarcharCol("wechatnum", "微信", "微信", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("name", "姓名", "姓名", 50, true, false, false, "", 4));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new VarcharCol("company", "单位名称", "单位名称", 500, true, false, false, "", 11));
    arrayList.add(new VarcharCol("position", "职位", "职位", 50, true, false, false, "", 13));
    arrayList.add(new VarcharCol("tag", "标签", "标签", 500, true, false, false, "", 10));
    arrayList.add(new VarcharCol("depname", "部门名称", "部门名称", 50, false, false, false, "", 12));
    arrayList.add(new VarcharCol("fax", "传真号", "传真号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("email", "电子邮箱", "电子邮箱", 50, true, false, false, "", 8));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 14));
    return arrayList;
  }
}
