package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_parameter implements YosObject {
  @Override
  public String table_comment() {
    return "系统参数设置";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_parameterid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new IntCol("sequence", "排序", "排序", true, false, false, 3));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 5));
    arrayList.add(new VarcharCol("paramvalue", "参数值", "参数值", 500, true, false, true, "", 3));
    arrayList.add(new VarcharCol("paramname", "参数", "参数", 50, true, false, true, "", 3));
    arrayList.add(new VarcharCol("remarks", "参数说明", "参数说明", 500, true, false, true, "", 4));
    arrayList.add(new SmallIntCol("ishide", "是否隐藏", "是否隐藏", true, false, false, 0, 3));
    return arrayList;
  }
}
