package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_optiontype implements YosObject {
  @Override
  public String table_comment() {
    return "系统选项分类表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("optiontypeid", "分类id");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new SmallIntCol("issubvaluemag", "是否二级分类管理", "是否二级分类管理", false, false, false, 0, 3));
    arrayList.add(new SmallIntCol("issql", "是否sql", "是否sql", false, false, false, 2));
    arrayList.add(new SmallIntCol("issystem", "是否系统分类", "是否系统分类", false, false, false, 4));
    arrayList.add(new VarcharCol("remarks", "备注", "备注", 500, true, false, false, "", 3));
    arrayList.add(new VarcharCol("typename", "分类名称", "分类名称", 50, false, true, false, "", 1));
    return arrayList;
  }
}
