package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_message implements YosObject {
  @Override
  public String table_comment() {
    return "用户消息表 ";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("messageid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("objectname", "消息归属数据表", "消息归属数据表", 50, true, false, false, "", 8));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 9));
    arrayList.add(new VarcharCol("message", "消息内容", "消息内容", 5000, false, false, false, "", 5));
    arrayList.add(new VarcharCol("title", "消息标题", "消息标题", 200, false, false, false, "", 4));
    arrayList.add(new VarcharCol("type", "消息类型", "消息类型", 50, false, false, false, "", 3));
    arrayList.add(new BigIntCol("userid", "账号id", "账号id", false, false, false, 2));
    arrayList.add(new LongTextCol("systemappids", "跳转应用ID", "跳转应用ID", true, false,"", 1));
    arrayList.add(new DateTimeCol("readdate", "阅读时间", "阅读时间", true, false, "", 10));
    arrayList.add(new SmallIntCol("isread", "是否已读", "是否已读", false, false, false, 6));
    arrayList.add(new BigIntCol("systemappid", "跳转应用ID", "跳转应用ID", true, false, false, 1));
    arrayList.add(new VarcharCol("siteid", "站点", "站点", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("objectid", "消息归属数据id", "消息归属数据id", true, false, false, 7));
    return arrayList;
  }
}
