package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_holidaylist implements YosObject {
  @Override
  public String table_comment() {
    return "周末及法定节假日表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_holidaylistid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new DateTimeCol("date", "日期", "", false, false, "", 3));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 1003));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 1004));
    arrayList.add(new VarcharCol("type", "类别", "法定节假日，周末", 50, false, false, false, "", 3));
    return arrayList;
  }
}
