package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_erpupdatelog implements YosObject {
  @Override
  public String table_comment() {
    return "erp上传日志表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_erpupdatelogid", "erp上传日志表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new LongTextCol("request", "请求内容", "请求内容", true, false, "", 3));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 1004));
    arrayList.add(new VarcharCol("errmsg", "错误信息", "错误信息", 5000, true, false, false, "", 3));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", true, false, false, 3));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("type", "类型", "类型", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 1003));
    arrayList.add(new LongTextCol("response", "返回内容", "返回内容", true, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", true, false, false, 1002));
    arrayList.add(new VarcharCol("erpbillno", "ERP单号", "ERP单号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("status", "返回状态", "返回状态", 50, true, false, false, "", 3));
    return arrayList;
  }
}
