package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_enterprise_tradefield implements YosObject {
  @Override
  public String table_comment() {
    return "企业领域授权表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_enterprise_tradefieldid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("hrid", "业务员人员id", "业务员人员id", true, false, false, 3));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 1007));
    arrayList.add(new BigIntCol("sa_saleareaid", "营销区域ID", "营销区域ID", true, false, false, 3));
    arrayList.add(new VarcharCol("tradefieldmx", "领域明细", "领域明细", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 3));
    arrayList.add(new BigIntCol("sa_agentsid", "经销商表ID", "经销商表ID", true, false, false, 3));
    arrayList.add(new VarcharCol("tradefield", "领域", "领域", 50, true, false, false, "", 3));
    return arrayList;
  }
}
