package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_enterprise_saleclass implements YosObject {
  @Override
  public String table_comment() {
    return "合作企业营销类别授权";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_enterprise_saleclassid", "合作企业营销类别授权ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("itemclassid", "营销类别表ID", "营销类别表ID", false, false, false, 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 2));
    return arrayList;
  }
}
