package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_enterprise_hr implements YosObject {
  @Override
  public String table_comment() {
    return "合作企业团队表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_enterprise_hrid", "合作企业团队表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new SmallIntCol("isleader", "是否商户负责人", "是否商户负责人", true, false, false, 8));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 10));
    arrayList.add(new VarcharCol("name", "姓名", "姓名", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("phonenumber", "手机号", "手机号", 50, true, false, false, "", 5));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 2));
    arrayList.add(new VarcharCol("position", "职位", "职位", 50, true, false, false, "", 4));
    arrayList.add(new BigIntCol("userid", "用户id", "用户id", false, false, false, 9));
    arrayList.add(new VarcharCol("email", "电子邮箱", "电子邮箱", 50, true, false, false, "", 6));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 7));
    return arrayList;
  }
}
