package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_enterprise_finance implements YosObject {
  @Override
  public String table_comment() {
    return "合作企业财务信息";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_enterprise_financeid", "合作企业财务信息ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("bank", "开户行", "开户行", 200, true, false, false, "", 6));
    arrayList.add(new VarcharCol("address", "开票地址", "开票地址", 500, true, false, false, "", 5));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 11));
    arrayList.add(new VarcharCol("phonenumber", "手机号", "手机号（电话）", 50, true, false, false, "", 8));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", true, false, false, 2));
    arrayList.add(new SmallIntCol("isdefault", "企业默认", "企业默认", false, false, false, 0, 0));
    arrayList.add(new VarcharCol("enterprisename", "抬头", "抬头", 200, true, false, false, "", 3));
    arrayList.add(new VarcharCol("taxno", "统一社会信用代码（税号）", "统一社会信用代码（税号）", 50, true, false, false, "", 4));
    arrayList.add(new VarcharCol("bankcardno", "开户账号", "开户账号", 50, true, false, false, "", 7));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 10));
    return arrayList;
  }
}
