package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_enterprise_contacts implements YosObject {
  @Override
  public String table_comment() {
    return "合作企业联系人表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("contactsid", "合作企业联系人表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new DateCol("birthday", "生日", "生日", true, true, "", 8));
    arrayList.add(new VarcharCol("city", "城市", "城市", 50, true, false, true, "", 12));
    arrayList.add(new VarcharCol("phonenumber", "手机号", "手机号", 50, true, false, true, "", 9));
    arrayList.add(new VarcharCol("county", "区县", "区县", 200, true, false, true, "", 13));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", true, false, false, 2));
    arrayList.add(new VarcharCol("province", "省份", "省份", 50, true, false, true, "", 11));
    arrayList.add(new VarcharCol("wechatnum", "微信", "微信", 50, true, false, true, "", 3));
    arrayList.add(new SmallIntCol("workaddress", "是否联系人", "是否联系人", false, false, false, 0, 16));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", true, false, false, 3));
    arrayList.add(new SmallIntCol("isdefault", "是否默认地址", "是否默认地址", true, false, false, 0, 3));
    arrayList.add(new VarcharCol("fax", "传真号", "传真号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("email", "电子邮箱", "电子邮箱", 50, true, false, true, "", 10));
    arrayList.add(new VarcharCol("address", "详细地址", "详细地址", 500, true, false, true, "", 15));
    arrayList.add(new SmallIntCol("isleader", "是否负责人", "是否负责人", true, false, true, 7));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 17));
    arrayList.add(new VarcharCol("sex", "性别", "性别", 10, true, false, true, "", 4));
    arrayList.add(new VarcharCol("telephone", "座机号、固定电话", "座机号、固定电话", 50, true, false, true, "", 3));
    arrayList.add(new SmallIntCol("isprimary", "是否主要地址", "是否主要地址", true, false, false, 0, 3));
    arrayList.add(new SmallIntCol("deleted", "删除状态", "删除状态", true, false, false, 0, 3));
    arrayList.add(new VarcharCol("name", "姓名", "姓名", 50, true, false, true, "", 3));
    arrayList.add(new VarcharCol("position", "职位", "职位", 50, true, false, true, "", 6));
    arrayList.add(new VarcharCol("depname", "部门名称", "部门名称", 50, true, false, true, "", 5));
    arrayList.add(new VarcharCol("taxno", "统一社会信用代码（税号）", "统一社会信用代码（税号）", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 14));
    return arrayList;
  }
}
