package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_enterprise implements YosObject {
  @Override
  public String table_comment() {
    return "合作企业档案";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_enterpriseid", "合作企业档案ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new DecimalCol("freefreightamount", "免运费额度", "免运费额度（超过该金额不进行运费计算）", 16, 2, true, false, 0, 3));
    arrayList.add(new VarcharCol("entcode", "企业编号", "企业编号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("city", "城市", "城市", 50, true, false, false, "", 6));
    arrayList.add(new VarcharCol("latitude", "纬度", "纬度", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("county", "区县", "区县", 200, true, false, false, "", 7));
    arrayList.add(new VarcharCol("phonenumber", "法人手机号", "法人手机号", 50, true, false, false, "", 10));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 14));
    arrayList.add(new LongTextCol("industry", "所属行业", "所属行业", true, false,"", 3));
    arrayList.add(new VarcharCol("enterprisename", "企业名称", "企业名称", 200, true, false, false, "", 2));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 13));
    arrayList.add(new VarcharCol("province", "省份", "省份", 50, true, false, false, "", 5));
    arrayList.add(new VarcharCol("contact", "法人", "法人", 50, true, false, false, "", 9));
    arrayList.add(new SmallIntCol("ismain", "是否站点企业", "是否站点企业", false, false, false, 0, 3));
    arrayList.add(new BigIntCol("authuserid", "数据归属人账号ID", "数据归属人账号ID", true, false, false, 15));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", true, false, false, 12));
    arrayList.add(new IntCol("limitreturnday", "订单可退货天数", "订单可退货天数", true, false, false, 3));
    arrayList.add(new VarcharCol("longitude", "经度", "经度", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("address", "注册地址", "注册地址", 500, true, false, false, "", 8));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 16));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 17));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 18));
    arrayList.add(new VarcharCol("telephone", "电话（座机）", "电话（座机）", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("saleclassauth", "是否需要经营授权", "是否需要经营授权", false, false, false, 1, 4));
    arrayList.add(new VarcharCol("abbreviation", "企业简称", "企业简称", 50, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("standardsauth", "是否需要标准授权", "是否需要标准授权", true, false, false, 1, 3));
    arrayList.add(new IntCol("invoicingpoint", "开票节点", "开票节点（1:订单审核：2:发货）", false, false, false, 2, 3));
    arrayList.add(new IntCol("grade", "商户等级", "商户等级", true, false, false, 3));
    arrayList.add(new VarcharCol("taxno", "统一社会信用代码（税号）", "统一社会信用代码（税号）", 50, true, false, false, "", 11));
    return arrayList;
  }
}
