package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_departmenthrid implements YosObject {
  @Override
  public String table_comment() {
    return "部门人员范围表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_departmenthridid", "部门人员范围表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("hrid", "人员ID", "人员ID", true, false, false, 3));
    arrayList.add(new BigIntCol("departmentid", "部门ID", "部门ID", true, false, false, 2));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    return arrayList;
  }
}
