package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_department implements YosObject {
  @Override
  public String table_comment() {
    return "组织架构表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("departmentid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("depno", "部门编码", "部门编码", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("depfullno", "部门路径", "部门路径", 500, true, false, false, "", 6));
    arrayList.add(new VarcharCol("depfullid", "部门id路径", "部门id路径", 500, true, false, false, "", 1));
    arrayList.add(new IntCol("level", "层级", "层级", true, false, false, 10));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 13));
    arrayList.add(new VarcharCol("depfullname", "类别全称", "类别全称", 500, true, false, false, "", 5));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 12));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 14));
    arrayList.add(new BigIntCol("parentid", "父级部门id", "父级部门id", true, false, false, 2));
    arrayList.add(new IntCol("sequence", "部门排序", "部门排序", true, false, false, 9));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 11));
    arrayList.add(new VarcharCol("siteid", "站点", "站点", 50, false, false, false, "", 1));
    arrayList.add(new VarcharCol("depname", "部门名称", "部门名称", 50, false, false, false, "", 4));
    arrayList.add(new VarcharCol("remarks", "部门描述", "部门描述", 500, true, false, false, "", 7));
    arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 8));
    return arrayList;
  }
}
