package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_datateam implements YosObject {
  @Override
  public String table_comment() {
    return "数据团队表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_datateamid", "数据团队表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new SmallIntCol("isleader", "是否负责人", "是否负责人", true, false, true, 5));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 10));
    arrayList.add(new IntCol("leadernum", "第几任", "第几任（转手次数）", true, false, false, 0, 3));
    arrayList.add(new SmallIntCol("editable", "是否允许编辑数据", "是否允许编辑数据", false, false, false, 1, 3));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 11));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 9));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 12));
    arrayList.add(new BigIntCol("sys_enterpriseid", "合作企业档案ID", "合作企业档案ID", false, false, false, 0, 3));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", false, false, false, 6));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, false, false, false, "", 7));
    arrayList.add(new BigIntCol("userid", "团队成员账号id", "团队成员账号id", false, false, false, 2));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 8));
    arrayList.add(new VarcharCol("name", "姓名", "姓名", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new VarcharCol("position", "职位", "职位", 50, true, false, false, "", 4));
    return arrayList;
  }
}
