package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_datatag implements YosObject {
  @Override
  public String table_comment() {
    return "数据标签表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_datatagid", "数据标签表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new VarcharCol("tag", "标签", "标签", 500, true, false, false, "", 4));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", false, false, false, 2));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, false, false, false, "", 3));
    arrayList.add(new SmallIntCol("issystem", "是否系统标签", "是否系统标签", false, false, false, 0, 3));
    return arrayList;
  }
}
