package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_dataimport implements YosObject {
  @Override
  public String table_comment() {
    return "数据导入";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_dataimportid", "数据导入ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new SmallIntCol("autouniqueid", "自动生成唯一ID", "自动生成唯一ID", false, false, false, 1, 3));
    arrayList.add(new VarcharCol("uniquecolumnname", "唯一id字段名", "唯一id字段名", 200, true, false, false, "", 3));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 1007));
    arrayList.add(new LongTextCol("data_column", "导入数据字段", "导入数据字段", true, false,"", 3));
    arrayList.add(new LongTextCol("sqlstr", "sql语句", "sql语句", true, false, "", 3));
    arrayList.add(new VarcharCol("type", "导入类型", "insert、update", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("table_name", "表名称", "表名称", 30, false, false, false, "", 3));
    arrayList.add(new LongTextCol("table_column", "导入映射", "导入映射", true, false,"", 3));
    arrayList.add(new VarcharCol("importmode", "导入方式", "导入方式 数据查询、Excel", 50, true, false, false, "excel", 3));
    arrayList.add(new VarcharCol("datakey", "数据源名称", "数据源名称", 100, false, false, false, "", 3));
    arrayList.add(new LongTextCol("errdatarows", "错误数据行", "错误数据行", true, false,"", 3));
    arrayList.add(new IntCol("sequence", "排序", "排序", true, false, false, 3));
    arrayList.add(new LongTextCol("datarows", "导入数据", "导入数据", true, false,"", 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 3));
    arrayList.add(new SmallIntCol("status", "导入状态", "导入状态", false, false, false, 0, 3));
    return arrayList;
  }
}
