package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_datafunction implements YosObject {
  @Override
  public String table_comment() {
    return "系统函数注册表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_datafunctionid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new SmallIntCol("queryforpage", "查询是否支持分页", "查询是否支持分页", true, false, false, 0, 4));
    arrayList.add(new VarcharCol("functionname", "函数名称", "函数名称", 50, false, true, false, "", 1));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 6));
    arrayList.add(new LongTextCol("sqlstr", "sql语句", "sql语句", true, false, "", 3));
    arrayList.add(new VarcharCol("type", "函数类型", "query、update", 50, false, false, false, "query", 2));
    arrayList.add(new LongTextCol("params", "参数列表", "参数列表", true, false,"", 1));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 5));
    arrayList.add(new SmallIntCol("isused", "是否已被使用", "是否已被使用", true, false, false, 0, 7));
    return arrayList;
  }
}
