package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_datafollowup implements YosObject {
  @Override
  public String table_comment() {
    return "数据跟进表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_datafollowupid", "数据跟进表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 10));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 11));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 9));
    arrayList.add(new TextCol("dataextend", "扩展数据", "扩展数据,json格式", true, false, "", 3));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 12));
    arrayList.add(new VarcharCol("type", "跟进类型", "跟进类型", 50, false, false, true, "", 2));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", false, false, false, 5));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, false, false, false, "", 4));
    arrayList.add(new VarcharCol("content", "跟进内容", "跟进内容", 1000, true, false, true, "", 3));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 8));
    arrayList.add(new SmallIntCol("deleted", "删除状态", "删除状态", true, false, false, 0, 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", true, false, false, 7));
    return arrayList;
  }
}
