package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_dataextend implements YosObject {
  @Override
  public String table_comment() {
    return "数据扩展表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_dataextendid", "数据扩展表");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 5));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 6));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 7));
    arrayList.add(new VarcharCol("backreason", "退回原因", "退回原因", 500, true, false, false, "", 3));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", false, false, false, 3));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, false, false, false, "", 2));
    arrayList.add(new VarcharCol("systemclient", "数据来源端", "数据来源端", 50, true, false, false, "", 3));
    arrayList.add(new LongTextCol("standards", "产品标准", "产品标准", true, false,"", 3));
    arrayList.add(new VarcharCol("deletereason", "作废原因", "删除原因，作废原因", 500, true, false, false, "", 4));
    arrayList.add(new VarcharCol("erpagentnum", "ERP经销商编号", "ERP经销商编号", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new LongTextCol("warehousejson", "仓库信息", "仓库库位批号", true, false,"", 3));
    arrayList.add(new VarcharCol("erpbillno", "ERP单号", "ERP单号", 50, true, false, false, "", 3));
    return arrayList;
  }
}
