package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_contrllog implements YosObject {
    @Override
    public String table_comment() {
        return "系统操作日志表";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("sys_contrllogid", "系统操作日志表ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("actionby", "动作人", "动作人", 50, false, false, false, "", 8));
        arrayList.add(new BigIntCol("actionuserid", "动作人账号ID", "动作人账号ID", false, false, false, 7));
        arrayList.add(new VarcharCol("action", "动作", "动作", 50, true, false, false, "", 5));
        arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 3));
        arrayList.add(new DateTimeCol("actiondate", "动作时间", "动作时间", true, false, "", 9));
        arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", true, false, false, 4));
        arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, true, false, false, "", 3));
        arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 6));
        return arrayList;
    }
}
