package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_apiapps implements YosObject {
  @Override
  public String table_comment() {
    return "接口app关联";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_apiappsid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new IntCol("sequence", "排序", "排序", true, false, false, 3));
    arrayList.add(new DateTimeCol("lastrequesttime", "最近请求时间", "最近请求时间", true, false, "", 1));
    arrayList.add(new BigIntCol("systemappid", "应用id", "应用id", true, false, false, 1));
    arrayList.add(new VarcharCol("apiversion", "apiversion", "apiversion", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("apiid", "apiid", "apiid", 50, true, false, false, "", 2));
    return arrayList;
  }
}
