package common.data.db;

import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;

import java.math.BigDecimal;
import java.sql.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SQLiteMemory {
    private static Connection conn = null;

    private static void createConnect() {
        if (conn == null) {
            synchronized (SQLiteMemory.class) {
                try {
                    Class.forName("org.sqlite.JDBC");
                    conn = DriverManager.getConnection("jdbc:sqlite::memory:");
                    conn.setAutoCommit(false);
                    // runSqlUpdate("PRAGMA page_size = 4096;");
                } catch (Exception e) {
                    conn = null;
                    System.err.println("sqlite缓存数据库连接失败");
                }
            }
        }
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static void runSqlUpdate(String SQL) {
        createConnect();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(SQL);
            statement.executeUpdate();
            conn.commit();
        } catch (Exception e) {
            //System.err.println("conn" + conn);
            //System.err.println("sqlite缓存数据库更新失败:" + SQL + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static void runSqlUpdate(ArrayList<String> SQLlist) {
        createConnect();
        PreparedStatement statement = null;
        try {
            for (String sql : SQLlist) {
                statement = conn.prepareStatement(sql);
                statement.executeUpdate();
            }
            conn.commit();
        } catch (Exception e) {
            //System.err.println("conn" + conn);
            //System.err.println("sqlite缓存数据库更新失败:" + JSONArray.toJSON(SQLlist) + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static Rows runSqlQuery(String SQL) {
        createConnect();
        Rows rows = new Rows();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();

            ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            List<String> colNameList = new ArrayList<String>();
            List<String> colTypeList = new ArrayList<String>();
            for (int i = 0; i < colCount; i++) {
                colNameList.add(rsmd.getColumnName(i + 1));
                colTypeList.add(rsmd.getColumnTypeName(i + 1));
            }
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; i++) {
                    String key = colNameList.get(i);
                    String type = colTypeList.get(i).toLowerCase();
                    Object value;
                    switch (type) {
                        case "int":
                            value = resultSet.getInt(colNameList.get(i));
                            break;
                        case "bigint":
                            value = resultSet.getLong(colNameList.get(i));
                            break;
                        case "smallint":
                            value = resultSet.getShort(colNameList.get(i));
                            break;
                        case "float":
                        case "numeric":
                        case "decimal":
                            value = resultSet.getBigDecimal(colNameList.get(i));
                            break;
                        case "datetime":
                            value = resultSet.getString(colNameList.get(i));
                            if (value != null) {
                                value = ((String) value).replace(" 00:00:00.0", "");
                            }
                            break;
                        case "date":
                        default:
                            value = resultSet.getString(colNameList.get(i));
                            break;
                    }
                    if ("total".equals(key)) {
                        rows.totalRows = (Long) value;

                    } else if ("pageTotal".equals(key)) {
                        rows.totalPage = ((BigDecimal) value).longValue();
                    } else {
                        row.put(key, value);
                    }
                }
                rows.add(row);
            }
        } catch (Exception e) {
            System.err.println("sqlite缓存数据库执行查询失败:" + SQL + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                resultSet.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }

    /**
     * 新增一个数据库对象，里面设置表名及字段名称，每次调用的时候传入。如果不存在，则新增该表，如果存在则直接执行此sql
     */
    public static Rows runSqlQueryWithFieldMeta(String SQL) {
        createConnect();
        Rows rows = new Rows();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();

            ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            ArrayList<String> colNameList = new ArrayList<String>();
            ArrayList<String> colTypeList = new ArrayList<String>();
            HashMap<String, FieldMeta> getFieldMetaMap = new HashMap<>();
            for (int i = 0; i < colCount; i++) {
                colNameList.add(rsmd.getColumnName(i + 1));
                colTypeList.add(rsmd.getColumnTypeName(i + 1));
            }
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; i++) {
                    FieldMeta fieldmeta = new FieldMeta();
                    fieldmeta.setTable_name(rsmd.getTableName(i + 1));
                    fieldmeta.setColumn_name(rsmd.getColumnName(i + 1));
                    fieldmeta.setPrecision(rsmd.getPrecision(i + 1));
                    fieldmeta.setScale(rsmd.getScale(i + 1));
                    String Columnlabel = rsmd.getColumnLabel(i + 1);
                    fieldmeta.setColumn_label(Columnlabel);

                    String key = colNameList.get(i);
                    String type = colTypeList.get(i).toLowerCase();
                    Object value;
                    switch (type) {
                        case "int":
                            value = resultSet.getInt(colNameList.get(i));
                            fieldmeta.setFieldtype(Integer.class);
                            break;
                        case "bigint":
                            value = resultSet.getLong(colNameList.get(i));
                            fieldmeta.setFieldtype(Long.class);
                            break;
                        case "smallint":
                            value = resultSet.getShort(colNameList.get(i));
                            fieldmeta.setFieldtype(Integer.class);
                            break;
                        case "float":
                        case "numeric":
                        case "decimal":
                            value = resultSet.getBigDecimal(colNameList.get(i));
                            fieldmeta.setFieldtype(BigDecimal.class);
                            break;
                        case "datetime":
                            value = resultSet.getString(colNameList.get(i));
                            if (value != null) {
                                value = ((String) value).replace(" 00:00:00.0", "");
                            }
                            fieldmeta.setFieldtype(Date.class);
                            break;
                        case "date":
                        default:
                            value = resultSet.getString(colNameList.get(i));
                            fieldmeta.setFieldtype(String.class);
                            break;
                    }
                    if ("total".equals(key)) {
                        rows.totalRows = (Long) value;

                    } else if ("pageTotal".equals(key)) {
                        rows.totalPage = ((BigDecimal) value).longValue();
                    } else {
                        row.put(key, value);
                    }
                    getFieldMetaMap.put(Columnlabel, fieldmeta);
                }
                rows.add(row);
            }
            rows.setFieldList(colNameList);
            rows.setFieldMetaMap(getFieldMetaMap);
        } catch (Exception e) {
            System.err.println("sqlite缓存数据库执行查询失败:" + SQL + System.lineSeparator() + e.getMessage());
        } finally {
            try {
                resultSet.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }
}
