package common.data;

import beans.parameter.Parameter;
import common.YosException;
import common.data.db.DBConnect;
import common.parameter.properties;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class ExcelFactory2003 {
    private String filename;
    private HSSFWorkbook hssfWorkbook;
    private XSSFWorkbook xssfWorkbook;
    public Boolean isWrite = false;

    /**
     * 构造函数，创建一个exlce输出文件
     *
     * @param filename
     */
    public ExcelFactory2003(String filename) {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
        hssfWorkbook = new HSSFWorkbook();
    }

    /**
     * 根据InputStream生成一个excel文件
     */
    public ExcelFactory2003(InputStream inputStream) throws IOException {
        hssfWorkbook = new HSSFWorkbook(inputStream);
    }

    /**
     * 创建一个空白的sheet
     *
     * @param sheetname sheet名称
     * @return
     */
    public HSSFSheet addSheet(String sheetname) {
        return hssfWorkbook.createSheet(sheetname);
    }

    /**
     * 创建一个带数据的sheet
     *
     * @param sheetname sheet名称
     * @param datarows  数据
     * @return
     */
    public HSSFSheet addSheet(String sheetname, Rows datarows) {
        HSSFSheet sheet = hssfWorkbook.createSheet(sheetname);
        HSSFRow headrow = sheet.createRow(0);
        HSSFCellStyle hssfCellStyle = getHeadRowStyle();
        ArrayList<String> keylist = datarows.getFieldList();
        for (int i = 0; i < keylist.size(); i++) {
            HSSFCell hssFcell = headrow.createCell(i);
            hssFcell.setCellStyle(hssfCellStyle);
            hssFcell.setCellValue(keylist.get(i));
        }
        for (int n = 0; n < datarows.size(); n++) {
            Row row = datarows.get(n);
            HSSFRow datarow = sheet.createRow(n + 1);
            for (int i = 0; i < keylist.size(); i++) {
                Class fieldclazztype = datarows.getFieldMeta(keylist.get(i)).getFieldtype();
                if (fieldclazztype == Integer.class) {
                    datarow.createCell(i).setCellValue(row.getInteger(keylist.get(i)));
                } else if (fieldclazztype == Long.class) {
                    datarow.createCell(i).setCellValue(row.getLong(keylist.get(i)));
                } else if (fieldclazztype == Float.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).floatValue());
                } else if (fieldclazztype == Double.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).doubleValue());
                } else {
                    datarow.createCell(i).setCellValue(row.getString(keylist.get(i)));
                }
            }
        }
        return sheet;
    }

    /**
     * 创建一个带数据的sheet，并且可以指定标题名称
     *
     * @param sheetname sheet名称
     * @param datarows  数据
     * @param titlemap  标题重命名
     * @return
     */
    public HSSFSheet addSheet(String sheetname, Rows datarows, HashMap<String, String> titlemap) {
        HSSFSheet sheet = hssfWorkbook.createSheet(sheetname);
        HSSFRow headrow = sheet.createRow(0);
        HSSFCellStyle hssfCellStyle = getHeadRowStyle();
        ArrayList<String> keylist = datarows.getFieldList();
        for (int i = 0; i < keylist.size(); i++) {
            HSSFCell hssFcell = headrow.createCell(i);
            hssFcell.setCellStyle(hssfCellStyle);
            String keyname = keylist.get(i);
            if (titlemap.containsKey(keyname)) {
                keyname = titlemap.get(keyname);
            }
            hssFcell.setCellValue(keyname);
        }
        for (int n = 0; n < datarows.size(); n++) {
            Row row = datarows.get(n);
            HSSFRow datarow = sheet.createRow(n + 1);
            for (int i = 0; i < keylist.size(); i++) {
                Class fieldclazztype = datarows.getFieldMeta(keylist.get(i)).getFieldtype();
                if (fieldclazztype == Integer.class) {
                    datarow.createCell(i).setCellValue(row.getInteger(keylist.get(i)));
                } else if (fieldclazztype == Long.class) {
                    datarow.createCell(i).setCellValue(row.getLong(keylist.get(i)));
                } else if (fieldclazztype == Float.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).floatValue());
                } else if (fieldclazztype == Double.class) {
                    datarow.createCell(i).setCellValue(row.getBigDecimal(keylist.get(i)).doubleValue());
                } else {
                    datarow.createCell(i).setCellValue(row.getString(keylist.get(i)));
                }
            }
        }
        return sheet;
    }

    /**
     * 开始写入磁盘
     *
     * @throws IOException
     */
    public void write() throws IOException, YosException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(Parameter.get("system_excelexport_path") + this.filename + ".xls"));
        hssfWorkbook.write(fileOutputStream);
        fileOutputStream.close();
        isWrite = true;
    }

    public String getFilename() {
        return this.filename + ".xls";
    }

    public String getFilepath() throws YosException {
        return Parameter.get("system_excelexport_path") + this.filename + ".xls";
    }

    public File getFile() throws YosException {
        return new File(Parameter.get("system_excelexport_path") + this.filename + ".xls");
    }

    public void deletefile() throws YosException {
        File file = new File(Parameter.get("system_excelexport_path") + this.filename + ".xls");
        file.delete();
    }

    /**
     * 默认标题样式
     *
     * @return
     */
    public HSSFCellStyle getHeadRowStyle() {
        HSSFCellStyle hssfCellStyle = hssfWorkbook.createCellStyle();
        hssfCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        hssfCellStyle.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        hssfCellStyle.setAlignment(HorizontalAlignment.CENTER);
        hssfCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = hssfWorkbook.createFont();
        font.setFontHeightInPoints((short) 12);//字号
        font.setBold(true);//加粗
        hssfCellStyle.setFont(font);
        return hssfCellStyle;
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    /**
     * 获取sheet
     *
     * @param sheetname sheet名称
     * @return
     */
    public HSSFSheet getSheet(String sheetname) {
        return this.hssfWorkbook.getSheet(sheetname);
    }

    /**
     * 获取sheet
     *
     * @param sheetindex sheet位置
     * @return
     */
    public HSSFSheet getSheet(int sheetindex) {
        return this.hssfWorkbook.getSheetAt(sheetindex);
    }

    /**
     * 将sheet转换成Rows
     *
     * @param sheetname sheet名称
     * @param rows      从数据库查询结果为空的rows
     * @param index     开始行数
     * @return
     */
    public Rows getSheetRows(String sheetname, Rows rows, int index) {
        return getSheetRows(sheetname, rows.getFieldList(), index);
    }

    /**
     * 将sheet转换成Rows
     *
     * @param sheetindex sheet位置
     * @param rows       从数据库查询结果为空的rows
     * @param index      开始行数
     * @return
     */
    public Rows getSheetRows(int sheetindex, Rows rows, int index) {
        return getSheetRows(sheetindex, rows.getFieldList(), index);
    }


    /**
     * 将sheet转换成Rows
     *
     * @param sheetname sheet名称
     * @param fieldlist 字段key
     * @param rowindex  开始行数
     * @return
     */
    public Rows getSheetRows(String sheetname, ArrayList<String> fieldlist, int rowindex) {
        int sheetindex = this.hssfWorkbook.getSheetIndex(sheetname);
        return getSheetRows(sheetindex, fieldlist, rowindex);
    }

    /**
     * 将sheet转换成Rows
     *
     * @param sheetindex sheet位置
     * @param fieldlist  字段key
     * @param rowindex   开始行数
     * @return
     */
    public Rows getSheetRows(int sheetindex, ArrayList<String> fieldlist, int rowindex) {
        HSSFSheet sheet = this.hssfWorkbook.getSheetAt(sheetindex);
        int rowcount = sheet.getPhysicalNumberOfRows();
        Rows rows = new Rows();
        rows.setFieldList(fieldlist);
        for (; rowindex < rowcount; rowindex++) {
            Row row = new Row();
            HSSFRow hssfRow = sheet.getRow(rowindex);
            int columncount = hssfRow.getPhysicalNumberOfCells();
            for (int n = 0; n < columncount; n++) {
                HSSFCell cell = hssfRow.getCell(n);
                cell.setCellType(CellType.STRING);
                if (fieldlist.size() > n) {
                    String fieldname = fieldlist.get(n);
                    try {
                        row.put(fieldname, cell.getStringCellValue());
                    } catch (Exception e) {
                        row.put(fieldname, "");
                    }
                }
            }
            rows.add(row);
        }
        return rows;
    }

    /**
     * 关闭
     */
    public void close() {
        if (hssfWorkbook != null) {
            try {
                hssfWorkbook.close();
                hssfWorkbook = null;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws YosException, IOException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select *from sys_users");
        ExcelFactory2003 excelFactory = new ExcelFactory2003("asdas");
        excelFactory.addSheet("nihao", rows);

        ArrayList<String> list = new ArrayList<>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        list.add("e");
        list.add("f");
        list.add("g");
        list.add("h");
        Rows rows3 = excelFactory.getSheetRows(0, list, 1);
        excelFactory.write();
        excelFactory.close();
    }
}
