package common.api;

import beans.parameter.Parameter;
import beans.socket.Socket;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import common.*;
import common.annotation.*;
import common.data.*;
import common.data.db.*;
import common.parameter.parameter;
import common.parameter.properties;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;
import org.reflections.Reflections;
import restcontroller.ClientUserInfo;
import utility.tools.WebRequest;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.*;

import static common.parameter.parameter.*;

public class YOSAPI extends BaseClass {
    private final Logger logger = Logger.getLogger(YOSAPI.class);
    private Class clazz;
    private Method method;
    private API api;
    private CACHEING cacheing = null;
    private boolean isCacheing = false;
    private CACHEING_CLEAN cacheing_clean = null;
    private boolean isCacheing_clean = false;
    private long id;
    private int version;

    public Class getClazz() {
        return clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public Method getMethod() {
        return method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public API getApi() {
        return api;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setApi(API api) {
        this.api = api;
    }

    public CACHEING getCacheing() {
        return cacheing;
    }

    public void setCacheing(CACHEING cacheing) {
        this.cacheing = cacheing;
    }

    public boolean isCacheing() {
        return isCacheing;
    }

    public boolean isCacheing_Clean() {
        return isCacheing_clean;
    }

    public CACHEING_CLEAN getCacheing_clean() {
        return cacheing_clean;
    }

    public void setCacheing_clean(CACHEING_CLEAN cacheing_clean) {
        this.cacheing_clean = cacheing_clean;
    }

    public static YOSAPI getApi(String className, String methodName) throws YosException {
        initialize();
        String cmkey = new StringBuffer(className).append("#").append(methodName).toString();
        if (!yosApiNameMap.containsKey(cmkey)) {
            throw new YosException("找不到" + className + "的" + methodName + "接口");
        }
        return yosApiNameMap.get(cmkey);
    }

    public static YOSAPI getApi(Class apiversionclass) throws YosException {
        String apiversion = apiversionclass.getName().toLowerCase();
        if (apiversion.startsWith("restcontroller.r$id") && apiversion.contains("$v")) {
            int version = Integer.parseInt(apiversionclass.getSimpleName().replace("v", ""));
            long apiid = Long.parseLong(apiversion.replace("restcontroller.r$id", "").replace("$v" + version, ""));
            return getApi(apiid, version);
        }
        return null;
    }

    /**
     * @param apiid      接口id
     * @param apiversion 接口版本 如果该值传0，则表示不指定版本，系统默认按照最大版本执行
     * @return
     * @throws Exception
     */
    public static YOSAPI getApi(long apiid, int apiversion) throws YosException {
        initialize();
        if (!yosApiIDMap.containsKey(apiid)) {
            throw new YosException("找不到ID为" + apiid + "的接口");
        }
        HashMap<Integer, YOSAPI> map = yosApiIDMap.get(apiid);
        if (apiversion > 0) {
            if (!map.containsKey(apiversion)) {
                throw new YosException("找不到ID为" + apiid + "version为" + apiversion + "的接口");
            }
            return map.get(apiversion);
        } else {
            int maxVersion = 0;
            for (int version : map.keySet()) {
                if (version > maxVersion) {
                    maxVersion = version;
                }
            }
            if (!map.containsKey(maxVersion)) {
                throw new YosException("找不到ID为" + apiid + "version为" + maxVersion + "的接口");
            }
            return map.get(maxVersion);
        }
    }

    /**
     * 接口初始化
     */
    public static void initialize() {
        synchronized (YOSAPI.class) {
            if (!isinit) {
                Reflections reflections = new Reflections("restcontroller");
                Set<Class<? extends Controller>> subTypes = reflections.getSubTypesOf(Controller.class);
                for (Class<? extends Controller> clazz : subTypes) {
                    Method[] methods = clazz.getDeclaredMethods();
                    for (Method method : methods) {
                        if (method.isAnnotationPresent(API.class)) {
                            API api = method.getAnnotation(API.class);
                            YOSAPI yosapi = new YOSAPI();
                            yosapi.setClazz(clazz);
                            yosapi.setMethod(method);
                            yosapi.setApi(api);
                            if (method.isAnnotationPresent(CACHEING.class)) {
                                yosapi.setCacheing(method.getAnnotation(CACHEING.class));
                                yosapi.isCacheing = true;
                            }
                            if (method.isAnnotationPresent(CACHEING_CLEAN.class)) {
                                yosapi.setCacheing_clean(method.getAnnotation(CACHEING_CLEAN.class));
                                yosapi.isCacheing_clean = true;
                            }

                            String apiversion = api.apiversion().getName().toLowerCase();
                            if (apiversion.startsWith("restcontroller.r$id") && apiversion.contains("$v")) {
                                /*
                                 *如果接口设置了id
                                 */
                                int version = Integer.parseInt(api.apiversion().getSimpleName().replace("v", ""));
                                long apiid = Long.parseLong(apiversion.replace("restcontroller.r$id", "").replace("$v" + version, ""));


                                HashMap<Integer, YOSAPI> idapimap;
                                if (yosApiIDMap.containsKey(apiid)) {
                                    idapimap = yosApiIDMap.get(apiid);
                                } else {
                                    idapimap = new HashMap<>();
                                }
                                yosapi.setId(apiid);
                                yosapi.setVersion(version);

                                idapimap.put(version, yosapi);
                                yosApiIDMap.put(apiid, idapimap);
                                yosApiVersionsMap.put(api.apiversion(), yosapi);
                            }
//                            else {
//                                //对于老的接口还未绑定apiversion的，系统允许通过路径调用
//                                String cmkey = new StringBuffer(clazz.getName()).append("#").append(method.getName()).toString();
//                                yosApiNameMap.put(cmkey, yosapi);
//                            }

                            String cmkey = new StringBuffer(clazz.getName()).append("#").append(method.getName()).toString();
                            yosApiNameMap.put(cmkey, yosapi);
                        }
                    }
                }
                isinit = true;

                try {
                    Rows rows = new DBConnect().runSqlQuery("select * from sys_api");
                    for (Row row : rows) {
                        apiintervaltimeMap.put(getApi(row.getLong("apiid"), row.getInteger("apiversion")).getApi(), row.getLong("intervaltime"));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
    }

    private static HashMap<API, Long> apiintervaltimeMap = new HashMap<>();

    /**
     * 设置接口请求间隔
     *
     * @param apiid
     * @param apiversion
     * @param intervaltime
     * @throws YosException
     */
    public static void setApiIntervaltime(long apiid, int apiversion, long intervaltime) throws YosException {
        apiintervaltimeMap.put(getApi(apiid, apiversion).getApi(), intervaltime);
    }

    public long getApiIntervaltime() {
        long intervaltime = apiintervaltimeMap.getOrDefault(getApi(), getApi().intervaltime());
        return (intervaltime == -1) ? 1000 : intervaltime;
    }

    /**
     * 接口请求验证
     *
     * @return
     * @throws YosException
     */
    private Object request_validate(YosRequest request) throws YosException {
        if (getApi().accesstoken()) {
            if ("".equals(request.getAccesstoken()) || (!parameter.tokenlist.containsKey(request.getAccesstoken()) && !istokeninuserlist(request))) {
                //如果缓存中不存在，则在账号列表中进行查询，查到结果后，将tokne存入缓存
                return new ReturnObject_Err().setErrCode(-1).setErrMsg("登陆状态已过期，请重新登陆！");
            }
            if (Parameter.get("system_sessionidcheck").equalsIgnoreCase("true")) {
                if (!parameter.tokenSessionidlist.containsKey(request.getAccesstoken()) || !parameter.tokenSessionidlist.get(request.getAccesstoken()).equals(request.getRequestsessionid())) {
                    return new ReturnObject_Err().setErrCode(-1).setErrMsg("身份令牌无效，请重新登陆！");
                }
            }
        }
        if (request.isdebug && !Parameter.get("system_runmode_debug").equalsIgnoreCase("true")) {
            return new ReturnObject_Err().setErrMsg("系统非调试模式下，不可执行此操作！");
        }
        if (!isCacheing()) {
            /*
             * 用户接口请求时间间隔校验，防止请求太过频繁
             */
            long intervaltime = getApiIntervaltime();
            if (intervaltime > 0) {
                synchronized (YOSAPI.class) {
                    Map<String, Long> userintervaltimemap;
                    if (APIIntervaltimeCheck.containsKey(method)) {
                        userintervaltimemap = APIIntervaltimeCheck.get(method);
                        if (userintervaltimemap.containsKey(request.getAccesstoken()) && userintervaltimemap.get(request.getAccesstoken()) > Calendar.getInstance().getTimeInMillis()) {
                            if (getApi().accesstoken()) {
                                return new ReturnObject_Err().setErrMsg("操作太过频繁，请稍后再试！");
                            } else {
                                return new ReturnObject_Err().setErrMsg("系统繁忙，请稍后再试！");
                            }
                        }
                    } else {
                        userintervaltimemap = new HashMap<>();
                    }
                    userintervaltimemap.put(request.getAccesstoken(), Calendar.getInstance().getTimeInMillis() + intervaltime);
                    APIIntervaltimeCheck.put(method, userintervaltimemap);
                }
            }
        }
        return null;
    }

    public static boolean isinit = false;
    protected static HashMap<String, YOSAPI> yosApiNameMap = new HashMap<>();
    public static HashMap<Long, HashMap<Integer, YOSAPI>> yosApiIDMap = new HashMap<>();

    protected static HashMap<Class, YOSAPI> yosApiVersionsMap = new HashMap<>();

    /**
     * 接口执行
     *
     * @throws YosException
     */
    public Object action(YosRequest request) throws YosException {
        request.setClasspath(getClazz().getName());
        request.setMethodname(getMethod().getName());

        String requestlogid = saveRequestLog(request);

        Object validateObject = request_validate(request);
        if (validateObject != null) {
            return validateObject;
        }
        long starttimes = Calendar.getInstance().getTimeInMillis();
        String result = null;
        /**
         * 如果方法中包含需缓存注释，则试图从缓存中获取数据
         */
        if (isCacheing() && !(Boolean) request.getContent().getOrDefault("nocache", false)) {
            Object data = DataPool.get(request);
            if (data != null) {
                result = data.toString();
                saveCallMethodMsg(getClazz().getName() + "." + getMethod().getName(), false, starttimes);
                if (Parameter.get("system_api_requestlog").equalsIgnoreCase("true")) {
                    SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestlog");
                    if (!sqLiteTable.dosNotExist()) {
                        SQLiteMemory.runSqlUpdate("update apirequestlog set iscacheing=1  where requestlogid='" + requestlogid + "'");
                    }
                }
            }
        }

        Object obj = null;
        try {
            request.getContent().put("accesstoken", request.getAccesstoken());
            if (result == null) {
                Constructor cla = getClazz().getDeclaredConstructor(JSONObject.class);
                obj = cla.newInstance(request.getContent());
                obj.getClass().getMethod("setYosapi", YOSAPI.class, YOSAPI.YosRequest.class).invoke(obj, this, request);
                obj.getClass().getMethod("setSorting").invoke(obj);
                if (request.getFileItems() != null) {
                    obj.getClass().getMethod("setrequestFileItemList", List.class).invoke(obj, request.getFileItems());
                }
                result = (String) getMethod().invoke(obj);
                if (isCacheing()) {
                    DataPool.put(request, result, getCacheing().life());
                }
                saveCallMethodMsg(getClazz().getName() + "." + getMethod().getName(), true, starttimes);
            }
            /**
             * 如果方法中包含需清理缓存的注释，则将指定的缓存进行清除
             */
            if (isCacheing_clean) {
                cacheingclean(request);
            }
            createUserRequestLog(request);
        } catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
            return new ReturnObject_Err().setErrMsg("类" + getClazz().getName() + "实例化异常");
        } catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
            return new ReturnObject_Err().setErrMsg("类" + getClazz().getName() + "安全权限异常，可能该类为非public类");
        } catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), e);
            return new ReturnObject_Err().setErrMsg("找不到指定的类" + getClazz().getName() + "的" + getMethod().getName() + "方法");
        } catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), e);
            return new ReturnObject_Err().setErrMsg("类" + getClazz().getName() + "的" + getMethod().getName() + "方法参数不合法");
        } catch (InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            Throwable targetException = e.getTargetException();
            targetException.printStackTrace();
            ReturnObject_Err d3BReturnObject_err = new ReturnObject_Err();
            d3BReturnObject_err.setErrMsg(targetException.getMessage());
            return d3BReturnObject_err;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return new ReturnObject_Err().setErrMsg("发生未知异常" + e.getMessage());
        } finally {
            if (!requestlogid.equals("")) {
                saveSQLLog(obj, requestlogid);
            }
        }
        return JSON.parse(result, Feature.OrderedField);
    }

    private HashMap<String[], Rows> dataCleanTableRows = new HashMap<>();
    private HashMap<String[], Rows> dataCleanAppRows = new HashMap<>();

    /**
     * 缓存清理
     *
     * @param request
     * @throws YosException
     */
    private void cacheingclean(YosRequest request) throws YosException {
        ArrayList<Long> cacheing_cleanUserids = request.getCacheing_cleanUsers();
        /*
        清除通过类名及方法名指定的缓存指令
         */
        cm[] cms = getCacheing_clean().cms();
        for (cm cm : cms) {
            String classpath = cm.clazz().getName();
            String[] methods = cm.method();
            for (String method : methods) {
                DataPool.remove(request.getAccesstoken(), classpath, method);
                for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                    DataPool.remove(cacheing_cleanUserid, classpath, method);
                }
            }
        }
        /*
        清除通过apiid指定的缓存指令
         */
        Class[] apiversions = getCacheing_clean().apiversions();
        for (Class clazz : apiversions) {
            String clazzSimpleName = clazz.getSimpleName().toLowerCase();
            if (clazzSimpleName.startsWith("v")) {
                        /*
                            如果清理缓存设定了接口版本，则清除指定版本的缓存信息
                             */
                if (yosApiVersionsMap.containsKey(clazz)) {
                    YOSAPI yosapi = yosApiVersionsMap.get(clazz);
                    String classpath = yosapi.getClazz().getName();
                    String method = yosapi.getMethod().getName();
                    DataPool.remove(request.getAccesstoken(), classpath, method);
                    for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                        DataPool.remove(cacheing_cleanUserid, classpath, method);
                    }
                }
            } else if (clazzSimpleName.startsWith("id")) {
                            /*
                            如果清理缓存只设定了接口id，没有指定版本，则默认清除所有版本的缓存信息
                             */
                long apiid = Long.parseLong(clazzSimpleName.replace("id", ""));
                if (yosApiIDMap.containsKey(apiid)) {
                    HashMap<Integer, YOSAPI> apiversionmap = yosApiIDMap.get(apiid);
                    for (int version : apiversionmap.keySet()) {
                        YOSAPI yosapi = apiversionmap.get(version);
                        String classpath = yosapi.getClazz().getName();
                        String method = yosapi.getMethod().getName();
                        DataPool.remove(request.getAccesstoken(), classpath, method);
                        for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                            DataPool.remove(cacheing_cleanUserid, classpath, method);
                        }
                    }
                }
            }
        }
        /*
        清除通过类指定的缓存指令
         */
        Class[] apiClasses = getCacheing_clean().apiClass();
        for (Class apiClass : apiClasses) {
            DataPool.remove(request.getAccesstoken(), apiClass.getName());
            for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                DataPool.remove(cacheing_cleanUserid, apiClass.getName());
            }
        }
        /*
        清除通过表名指定的缓存指令
         */
        String[] tablenames = getCacheing_clean().tablename();
        if (tablenames.length > 0) {
            Rows tablenameRows = null;
            if (dataCleanTableRows.containsKey(tablenames)) {
                tablenameRows = dataCleanTableRows.get(tablenames);
            } else {
                SQLFactory tablenameapiquery = new SQLFactory("sql:select distinct t2.apiid,t2.apiversion from sys_objectapps t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.table_name in $table_name$");
                tablenameapiquery.addParameter_in("table_name", tablenames);
                tablenameRows = tablenameapiquery.runSqlQuery(dbConnect);
                dataCleanTableRows.put(tablenames, tablenameRows);
            }
            for (Row tablenameRow : tablenameRows) {
                long apiid = tablenameRow.getLong("apiid");
                int apiversion = tablenameRow.getInteger("apiversion");
                try {
                    YOSAPI yosapi = YOSAPI.getApi(apiid, apiversion);
                    DataPool.remove(request.getAccesstoken(), yosapi.getClazz().getName(), yosapi.method.getName());
                    for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                        DataPool.remove(cacheing_cleanUserid, yosapi.getClazz().getName(), yosapi.method.getName());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        /*
        清除通过应用名指定的缓存指令
         */
        String[] systemapps = getCacheing_clean().systemapp();
        if (systemapps.length > 0) {
            Rows systemappsRows = null;
            if (dataCleanAppRows.containsKey(systemapps)) {
                systemappsRows = dataCleanAppRows.get(systemapps);
            } else {
                SQLFactory systemappquery = new SQLFactory("sql:select distinct t2.apiid,t2.apiversion from sys_systemapp t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.systemapp in $systemapp$");
                systemappquery.addParameter_in("systemapp", systemapps);
                systemappsRows = systemappquery.runSqlQuery(dbConnect);
                dataCleanAppRows.put(tablenames, systemappsRows);
            }
            for (Row systemappsRow : systemappsRows) {
                long apiid = systemappsRow.getLong("apiid");
                int apiversion = systemappsRow.getInteger("apiversion");
                try {
                    YOSAPI yosapi = YOSAPI.getApi(apiid, apiversion);
                    DataPool.remove(request.getAccesstoken(), yosapi.getClazz().getName(), yosapi.method.getName());
                    for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                        DataPool.remove(cacheing_cleanUserid, yosapi.getClazz().getName(), yosapi.method.getName());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String day = "";

    private String saveRequestLog(YosRequest request) throws YosException {
        String requestlogid = "";
        if (Parameter.get("system_api_requestlog").equalsIgnoreCase("true")) {
            requestlogid = request.requestKey + Calendar.getInstance().getTimeInMillis();
            /*
            如果是调试模式，则将请求内容进行记录
             */
            SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestlog");
            if (!sqLiteTable.dosNotExist()) {
                SQLiteTableData sqLiteTableData = sqLiteTable.makeData();
                sqLiteTableData.set("requestlogid", requestlogid);
                sqLiteTableData.set("classname", getClazz().getName().replace("restcontroller.", ""));
                sqLiteTableData.set("method", getMethod().getName());
                sqLiteTableData.set("createdate", getDateTime_Str());
                sqLiteTableData.set("request", request.getContent().toString(), true);
                if (tokenlist.containsKey(request.getAccesstoken())) {
                    if (usersiteIdList.containsKey(tokenlist.get(request.getAccesstoken()))) {
                        sqLiteTableData.set("usermsg", usersiteIdList.get(tokenlist.get(request.getAccesstoken())).toJsonObject().toJSONString());
                    } else {
                        sqLiteTableData.set("usermsg", "{}");
                    }
                } else {
                    sqLiteTableData.set("usermsg", "{}");
                }
                sqLiteTableData.insert();
            }
            if (request.getSystemappId() > 0 && getId() > 0) {
                String key = request.getSystemappId() + "-" + getId() + "-" + getVersion();
                if (!k.contains(key)) {
                    InsertSQL sqlFactory = SQLFactory.createInsertSQL(dbConnect, "sys_apiapps");
                    sqlFactory.setValue("sys_apiappsid", createTableID("sys_apiapps"));
                    sqlFactory.setValue("apiid", getId());
                    sqlFactory.setValue("apiversion", getVersion());
                    sqlFactory.setValue("systemappid", request.getSystemappId());
                    sqlFactory.setValue("sequence", 0);
                    sqlFactory.setValue("createflag", 1);
                    sqlFactory.setValue("lastrequesttime", getDateTime_Str());
                    sqlFactory.setWhere("not exists(select * from sys_apiapps where systemappid='" + request.getSystemappId() + "' and apiid='" + getId() + "' and apiversion='" + getVersion() + "')");
                    sqlFactory.insert();
                    k.add(key);
                } else {
                    UpdateSQL sqlFactory = SQLFactory.createUpdateSQL(dbConnect, "sys_apiapps");
                    sqlFactory.setValue("lastrequesttime", getDateTime_Str());
                    sqlFactory.setWhere("apiid", getId());
                    sqlFactory.setWhere("apiversion", getVersion());
                    sqlFactory.setWhere("systemappid", request.getSystemappId());
                    sqlFactory.update();
                }
            }
            if (!day.equals(getDate_Str())) {
                new Thread() {
                    @Override
                    public void run() {
                        super.run();
                        //自动删除两天前的请求记录
                        sqLiteTable.deleteData("datetime(createdate) < datetime('now','-2 day','localtime') ");
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(Calendar.DATE, -2);
                        SQLiteTable.getTable("apirequestsqllog").deleteData("createtimeinmillis < " + calendar.getTimeInMillis());
                    }
                }.start();
                day = getDate_Str();
            }
        }
        return requestlogid;
    }

    private static ArrayList<String> k = new ArrayList<>();


    /**
     * 保存数据执行日志
     *
     * @param obj
     */
    private void saveSQLLog(Object obj, String requestlogid) {
        try {
            if (obj != null && Parameter.get("system_db_sqllog").equalsIgnoreCase("true")) {
                    /*
                    如果是调试模式，则将请求内容进行记录
                     */
                SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestsqllog");
                if (!sqLiteTable.dosNotExist()) {
                    ArrayList<SQLLog> sqlLogList = (ArrayList<SQLLog>) obj.getClass().getMethod("getSQLLog").invoke(obj);
                    for (SQLLog sqlLog : sqlLogList) {
                        SQLiteTableData sqLiteTableData = sqLiteTable.makeData();
                        sqLiteTableData.set("requestlogid", requestlogid);
                        sqLiteTableData.set("runtime", sqlLog.getRuntime());
                        sqLiteTableData.set("sql", sqlLog.getSQL(), true);
                        sqLiteTableData.set("success", sqlLog.isSuccess() ? 1 : 0);
                        sqLiteTableData.set("errmsg", sqlLog.getErrmsg());
                        sqLiteTableData.set("createtimeinmillis", Calendar.getInstance().getTimeInMillis());
                        sqLiteTableData.set("numofaffectedrows", sqlLog.getNumofaffectedrows());
                        sqLiteTableData.insert();
                    }
                    sqlLogList.clear();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //usersiteid:tuserrequestlogid
    private static HashMap<Long, Long> userRequestLogMap = new HashMap<Long, Long>();
    //usersiteid:count
    private static HashMap<Long, Long> userRequestLogcountMap = new HashMap<Long, Long>();
    private static String lastday = "";
    private static long requestcount_today = 0L;
    private static long requestcount_today_lastsend = 0L;
    private static long requestcount_today_lastsendtimes = 0L;
    private static long requestusercount_today = 0L;

    /**
     * 创建请求日志
     */
    private void createUserRequestLog(YosRequest request) {
        if (tokenlist.containsKey(request.getAccesstoken())) {
            new Thread() {
                @Override
                public void run() {
                    try {
                        long usersiteid = tokenlist.get(request.getAccesstoken());
                        Row row = parameter.usersiteIdList.get(usersiteid);
                        long userid = row.getLong("userid");
                        String siteid = row.getString("siteid");
                        String nowday = getDate_Str();
                        if (!lastday.equals(nowday)) {
                            lastday = nowday;
                            userRequestLogMap.clear();

                            Rows rows = dbConnect.runSqlQuery("select sum(requesttimes)as requestcount_today,count(distinct userid)requestusercount_today from sys_userrequestlog where `date`= date_format(now(),'%Y-%m-%d')");
                            if (rows.isNotEmpty()) {
                                requestcount_today = rows.get(0).getBigDecimal("requestcount_today").longValue();
                                requestusercount_today = rows.get(0).getLong("requestusercount_today");
                            }
                        }
                        if (!userRequestLogMap.containsKey(usersiteid)) {
                            Rows rows = dbConnect.runSqlQuery("select userrequestlogid from sys_userrequestlog where usersiteid='" + usersiteid + "' and date_format(date,'%Y-%m-%d')=date_format(now(),'%Y-%m-%d')");
                            if (rows.isEmpty()) {
                                ArrayList<String> sqllist = new ArrayList<String>();
                                long userrequestlogid = createTableID("sys_userrequestlog");

                                SQLFactory deletesql = new SQLFactory(this, "请求日志删除");
                                deletesql.addParameter("usersiteid", usersiteid);
                                sqllist.add(deletesql.getSQL());

                                SQLFactory insertsql = new SQLFactory(this, "请求日志插入");
                                insertsql.addParameter("userrequestlogid", userrequestlogid);
                                insertsql.addParameter("usersiteid", usersiteid);
                                insertsql.addParameter("userid", userid);
                                insertsql.addParameter("siteid", siteid);
                                if (request.getHttpServletRequest() != null) {
                                    insertsql.addParameter("ip", WebRequest.getRequestIP(request.getHttpServletRequest()));
                                    insertsql.addParameter("useragent", WebRequest.getUserAgent(request.getHttpServletRequest()));
                                } else {
                                    insertsql.addParameter("ip", "");
                                    insertsql.addParameter("useragent", "");
                                }
                                sqllist.add(insertsql.getSQL());
                                dbConnect.runSqlUpdate(sqllist);
                                userRequestLogMap.put(usersiteid, userrequestlogid);
                            } else {
                                userRequestLogMap.put(usersiteid, rows.get(0).getLong("userrequestlogid"));
                            }
                            userRequestLogcountMap.put(usersiteid, 1L);
                        } else {
                            long count = userRequestLogcountMap.get(usersiteid) + 1;
                            if (count > 9) {
                                userRequestLogcountMap.put(usersiteid, 1L);
                                long userrequestlogid = userRequestLogMap.get(usersiteid);
                                dbConnect.runSqlUpdate("update sys_userrequestlog set lastrequestdate=now(),requesttimes=requesttimes+" + count + " where usersiteid='" + usersiteid + "' and userrequestlogid=" + userrequestlogid);
                            } else {
                                userRequestLogcountMap.put(usersiteid, count);
                            }
                        }

                        requestcount_today++;
                        long now = Calendar.getInstance().getTimeInMillis();
                        if (now - 2000 > requestcount_today_lastsendtimes) {
                            JSONObject object = new JSONObject();
                            object.put("requestcount_today", requestcount_today);
                            object.put("requestcount_today_lastsend", requestcount_today_lastsend);
                            object.put("requestusercount_today", requestusercount_today);

                            object.put("onlineusersiteaccount", parameter.websocketClients.size());

                            Socket.sendData("requestcount_today", object);

                            requestcount_today_lastsend = requestcount_today;
                            requestcount_today_lastsendtimes = now;
                        }
                    } catch (YosException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    /**
     * 记录请求数
     *
     * @param key
     * @param fromdb
     * @param starttime
     */
    private void saveCallMethodMsg(String key, boolean fromdb, long starttime) {
        long time = Calendar.getInstance().getTimeInMillis() - starttime;
        long callmethodTimes = parameter.callmethodTimes.getOrDefault(key, 0L);

        //更新请求总数
        parameter.callmethodTimes.put(key, callmethodTimes + 1L);

        //最新请求时间
        parameter.lastcallmethodtime.put(key, Calendar.getInstance().getTime());

        //从缓存获取的次数
        long callmethod_fromcacheTimes = parameter.callmethod_fromcacheTimes.getOrDefault(key, 0L);
        if (!fromdb) {
            /**
             * 方法请求从缓存获取次数
             */
            parameter.callmethod_fromcacheTimes.put(key, callmethod_fromcacheTimes + 1L);
        } else {
            /**
             * 方法请求查询最新耗时
             */
            parameter.callmethodLastTimeLong.put(key, time);


            long totaltimes = callmethodTimes - callmethod_fromcacheTimes;

            /**
             * 方法请求查询平均时间
             */
            long callmethodTimeLong = parameter.callmethodTimeLong.getOrDefault(key, 0L);

            parameter.callmethodTimeLong.put(key, (callmethodTimeLong * totaltimes + time) / (totaltimes + 1));
        }
    }

    /**
     * 从持久化账号中获取
     *
     * @return
     * @throws YosException
     */
    private boolean istokeninuserlist(YosRequest request) throws YosException {
        DBConnect dbConnect = new DBConnect();
        SQLFactory factory = null;
        if (Parameter.get("system_sessionidcheck").equalsIgnoreCase("true")) {
            factory = new SQLFactory(this, "持久化账号列表查询_sessionid");
            factory.addParameter("sessionid", request.getRequestsessionid());
        } else {
            factory = new SQLFactory(this, "持久化账号列表查询");
        }
        factory.addParameter("accesstoken", request.getAccesstoken());
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());
        if (rows.isEmpty()) {
            return false;
        } else {
            for (Row row : rows) {
                long usersiteid = row.getLong("usersiteid");
                row.put("logintime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()));
                if (request.getHttpServletRequest() != null) {
                    row.put("ip", WebRequest.getRequestIP(request.getHttpServletRequest()));
                    row.put("useragent", WebRequest.getUserAgent(request.getHttpServletRequest()));
                } else {
                    row.put("ip", "");
                    row.put("useragent", "");
                }
                row.putAll(ClientUserInfo.setLoginReturn(usersiteid, row));
                parameter.usersiteIdList.put(usersiteid, row);
                parameter.tokenlist.put(request.getAccesstoken(), usersiteid);
                parameter.tokenSessionidlist.put(request.getAccesstoken(), request.getRequestsessionid());
            }
            return true;
        }
    }

    public static class YosRequest {
        private HttpServletRequest httpServletRequest = null;
        private String requestKey = null;
        private String accesstoken = null;
        private String requestsessionid = null;
        private JSONObject content = null;
        private String classpath = null;
        private String methodname = null;
        private long systemappid = 0;
        private boolean isdebug = false;
        private List<FileItem> fileItems = null;
        private ArrayList<Long> cacheing_cleanUsers = new ArrayList<>();

        public List<FileItem> getFileItems() {
            return fileItems;
        }

        public YosRequest setFileItems(List<FileItem> fileItems) {
            this.fileItems = fileItems;
            return this;
        }

        public JSONObject getContent() {
            return content;
        }

        public YosRequest setContent(JSONObject content) {
            this.content = content;
            return this;
        }

        public boolean isdebug() {
            return isdebug;
        }

        public void setIsdebug(boolean isdebug) {
            this.isdebug = isdebug;
        }

        public String getAccesstoken() {
            return accesstoken;
        }

        public YosRequest setAccesstoken(String accesstoken) {
            this.accesstoken = accesstoken;
            return this;
        }

        public String getRequestsessionid() {
            return requestsessionid;
        }

        public YosRequest setRequestsessionid(String requestsessionid) {
            this.requestsessionid = requestsessionid;
            return this;
        }

        public String getRequestKey() {
            return requestKey;
        }

        public YosRequest setRequestKey(String requestKey) {
            this.requestKey = requestKey;
            return this;
        }

        public HttpServletRequest getHttpServletRequest() {
            return httpServletRequest;
        }

        public YosRequest setHttpServletRequest(HttpServletRequest httpServletRequest) {
            this.httpServletRequest = httpServletRequest;
            return this;
        }

        public String getClasspath() {
            return classpath;
        }

        public void setClasspath(String classpath) {
            this.classpath = classpath;
        }

        public String getMethodname() {
            return methodname;
        }

        public void setMethodname(String methodname) {
            this.methodname = methodname;
        }

        public long getUsersiteid() {
            return tokenlist.getOrDefault(getAccesstoken(), 0L);
        }

        public Row getUserRow() {
            return usersiteIdList.getOrDefault(getUsersiteid(), null);
        }


        public ArrayList<Long> getCacheing_cleanUsers() {
            return cacheing_cleanUsers;
        }

        public void addCacheing_cleanUser(Long userid) {
            this.cacheing_cleanUsers.add(userid);
        }

        public long getSystemappId() {
            return systemappid;
        }

        public YosRequest setSystemappId(long systemappid) {
            this.systemappid = systemappid;
            return this;
        }
    }
}
