/**
 *
 */
package common;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.data.*;
import common.data.db.DBConnect;
import common.data.db.SQLLog;
import common.parameter.parameter;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import utility.tools.GetPinYin;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;

import static common.parameter.parameter.usersiteIdList;

/**
 * @author Administrator
 *
 */
public class BaseClass {
    public enum JOINTYPE {
        inner, left, right
    }

    /**
     * 默认的数据库链接对象
     */
    public DBConnect dbConnect = null;

    public Date sysdate;
    public static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public BaseClass() {
        this.dbConnect = new DBConnect();
        try {
            this.dbConnect.setCreatesqllog(Parameter.get("system_db_sqllog").equalsIgnoreCase("true"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        sysdate = getDateTime();
    }

    public ArrayList<SQLLog> getSQLLog() {
        return this.dbConnect.getSqlLogList();
    }

    /**
     * 获取本周第一天的日期
     * @return
     */
    public static String getWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        calendar.set(Calendar.DAY_OF_WEEK, 1);
        calendar.set(Calendar.DATE, calendar.get(Calendar.DATE) + 1);
        return format.format(calendar.getTime());
    }

    /**
     * 获取本周最后一天的日期
     * @return
     */
    public static String getWeekLastDay() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        calendar.set(Calendar.DAY_OF_WEEK, 7);
        calendar.set(Calendar.DATE, calendar.get(Calendar.DATE) + 1);
        return format.format(calendar.getTime());
    }

    /**
     * 获取本月第一天的日期
     * @return
     */
    public static String getMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return format.format(calendar.getTime());
    }

    /**
     * 获取本月最后一天的日期
     * @return
     */
    public static String getMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        return format.format(calendar.getTime());
    }

    /**
     * 获取当前系统日期，格式为yyyy-MM-dd
     *
     * @return
     */
    public static String getDate_Str() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime());
    }

    /**
     * 获取和当前日期指定间隔天数的日期
     * @param margin 间隔天数
     * @return
     */
    public static String getDate_Str(int margin) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, margin);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime());
    }

    /**
     *  获取指定时间的日期，格式为yyyy-MM-dd
     * @param date
     * @return
     */
    public static String getDate_Str(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date.getTime());
    }

    public static String getDate_Str(Long imeinmillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(imeinmillis);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime());
    }

    /**
     * 获取当前系统时间
     * @return
     */
    public static Date getDateTime() {
        return Calendar.getInstance().getTime();
    }

    /**
     * 获取当前系统日期
     * @return
     */
    public static Date getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取当前系统时间，格式为yyyy-MM-dd HH:mm:ss
     *
     * @return
     */
    public static String getDateTime_Str() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(calendar.getTime());
    }

    public static String getDateTime_Str(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date.getTime());
    }

    public static String getDateTime_Str(Long imeinmillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(imeinmillis);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(calendar.getTime());
    }

    /**
     * 判断字符串是否为空，如果为空则返回""，否则返回原值
     * @param str
     * @return
     */
    public String nullToStr(String str) {
        if (null == str || "null".equalsIgnoreCase(str)) {
            return "";
        } else {
            return str;
        }
    }

    /**
     * 判断文本对象是不是JSONObject格式
     * @param jsonStr
     * @return
     */
    public boolean isJSONObject(String jsonStr) {
        try {
            Object object = JSON.parse(jsonStr);
            return object instanceof JSONObject;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 判断文本对象是不是JSONArray格式
     * @param jsonStr
     * @return
     */
    public boolean isJSONArray(String jsonStr) {
        try {
            Object object = JSON.parse(jsonStr);
            return object instanceof JSONArray;
        } catch (Exception e) {
            return false;
        }
    }


    /**
     * 获取一个新的表数据ID
     */
    private static HashMap<String, Long> tableidmap = new HashMap<String, Long>();

    /**
     * 生成一个新的数据ID
     *
     * @param table_name 数据表名称
     * @return
     */
    public long createTableID(String table_name) throws YosException {
        return createTableID(table_name, 1)[0];
    }

    /**
     * 生成多个新的数据ID，
     *
     * @param table_name
     * @return
     */
    public long[] createTableID(String table_name, int count) throws YosException {
        synchronized (Controller.class) {
            table_name = table_name.toLowerCase();
            String fieldname = getuniquecolumnname(table_name);
            if (!tableidmap.containsKey(table_name)) {
                Rows tablemaxidrows = new DBConnect().runSqlQuery("select ifnull(max(" + fieldname + "),0) as " + fieldname + " from " + table_name);
                long maxtableid = tablemaxidrows.get(0).getLong(fieldname);

                Rows objectmaxidrows = new DBConnect().runSqlQuery("select ifnull(uniquecolumnmaxid,1)as uniquecolumnmaxid from sys_object where table_name='" + table_name + "'");
                long maxobjectid = (maxtableid == 0 ? 0 : objectmaxidrows.get(0).getLong("uniquecolumnmaxid"));

                tableidmap.put(table_name, Math.max(maxtableid, maxobjectid));
            }
            tableidmap.put(table_name, tableidmap.get(table_name) + count);
            dbConnect.runSqlUpdate("update sys_object set uniquecolumnmaxid=" + tableidmap.get(table_name) + " where table_name='" + table_name + "'");
            long firstid = tableidmap.get(table_name) - count + 1;
            long[] ids = new long[count];
            for (int index = 0; index < count; index++) {
                ids[index] = firstid++;
            }
            return ids;
        }
    }

    public void tableidmapClean(String table_name) {
        if (tableidmap.containsKey(table_name)) {
            tableidmap.remove(table_name);
        }
    }

    private static HashMap<String, String> uniquecolumnnamemap = new HashMap<String, String>();

    /**
     * 获取表唯一id字段
     *
     * @param table_name
     * @return
     */
    public String getuniquecolumnname(String table_name) throws YosException {
        table_name = table_name.toLowerCase();
        if (!uniquecolumnnamemap.containsKey(table_name)) {
            SQLFactory sqlFactory = new SQLFactory("表ID字段查询");
            sqlFactory.addParameter("table_name", table_name);
            Rows rows = new DBConnect().runSqlQuery(sqlFactory);
            for (Row row : rows) {
                uniquecolumnnamemap.put(row.getString("table_name").toLowerCase(), row.getString("uniquecolumnname").toLowerCase());
            }
        }
        return uniquecolumnnamemap.get(table_name);
    }


    /**
     * 根据userid获取账号信息
     *
     * @param userid
     * @return
     */
    public Row getUser(long userid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select  * from sys_users where userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }


    /**
     * 根据多个userid获取账号信息
     *
     * @param userids
     * @return
     */
    public RowsMap getUser(long userids[]) throws YosException {
        StringBuilder where = new StringBuilder("''");
        for (long userid : userids) {
            where.append(",'").append(userid).append("'");
        }
        return dbConnect.runSqlQuery("select  * from sys_users where userid in(" + where + ")").toRowsMap("userid");
    }

    /**
     * 通知前端执行指定方法
     */
//    public void sendSystemWebSocketMessage(String classname, String method, long usersiteid) {
//        sendSystemWebSocketMessage(classname, method, new long[]{usersiteid});
//    }

    /**
     * 通知前端执行指定方法
     */
//    public void sendSystemWebSocketMessage(String classname, String method, long[] usersiteids) {
//        for (long usersiteid : usersiteids) {
//            if (parameter.websocketClients.containsKey(usersiteid)) {
//                JSONObject methodobject = new JSONObject();
//                methodobject.put("type", "callmethod");
//                methodobject.put("classname", classname);
//                methodobject.put("method", method);
//                for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
//                    webClientSocket.sendSystemMessage(methodobject);
//                }
//            }
//        }
//    }

//    public void sendSystemWebSocketMessage(String classname, String method) {
//        for (long usersiteid : parameter.websocketClients.keySet()) {
//            JSONObject methodobject = new JSONObject();
//            methodobject.put("type", "callmethod");
//            methodobject.put("classname", classname);
//            methodobject.put("method", method);
//            for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
//                webClientSocket.sendSystemMessage(methodobject);
//            }
//        }
//    }


    /**
     * 获取指定表的字段信息
     *
     * @param tablename
     * @return
     */
    public RowsMap getTableColumns(String tablename) throws YosException {
        tablename = tablename.toLowerCase();
        Rows rows = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + tablename + "'");
        return rows.toRowsMap("column_name");
    }


    /**
     * 获取指定表的字段信息
     *
     * @param tablename
     * @return
     */
    public ArrayList<String> getTableColumnNames(String tablename) throws YosException {
        if (!TableColumnNamesMaps.containsKey(tablename)) {
            TableColumnNamesMaps.put(tablename, dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + tablename + "'").toArrayList("column_name"));
        }
        return TableColumnNamesMaps.get(tablename);
    }

    private static HashMap<String, ArrayList<String>> TableColumnNamesMaps = new HashMap<>();

    public void cleanTableColumnNamesMaps(String tablename) {
        TableColumnNamesMaps.remove(tablename);
    }

    public static HashMap<String, HashMap<String, String>> ColumnTypeMap = new HashMap<>();

    public String getColumnType(String table_name, String column_name) throws YosException {
        if (!ColumnTypeMap.containsKey(table_name)) {
            HashMap<String, String> map = new HashMap<>();
            ColumnTypeMap.put(table_name, map);
        }
        if (!ColumnTypeMap.get(table_name).containsKey(column_name)) {
            Rows rows = dbConnect.runSqlQuery("select column_type from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
            if (rows.isNotEmpty()) {
                ColumnTypeMap.get(table_name).put(column_name, rows.get(0).getString("column_type").toLowerCase());
            }
        }
        return ColumnTypeMap.get(table_name).getOrDefault(column_name, "varchar");
    }


    private static HashMap<String, String> column_titleMaps = new HashMap<>();

    public String getTableColumnTitle(String tablename, String column_name) throws YosException {
        String key = tablename + "&" + column_name;
        if (!column_titleMaps.containsKey(key)) {
            Rows rows = dbConnect.runSqlQuery("select column_title from sys_objectcols where table_name='" + tablename + "' and column_name='" + column_name + "'");
            if (rows.isNotEmpty()) {
                column_titleMaps.put(key, rows.get(0).getString("column_title"));
            }
        }
        return column_titleMaps.getOrDefault(key, "未知");
    }

    public void cleanTableColumnTitle(String tablename, String column_name) {
        String key = tablename + "&" + column_name;
        column_titleMaps.remove(key);
    }

    private static HashMap<String, Boolean> siteTableMap = new HashMap<>();

    /**
     * 表是否为站点控制表
     *
     * @param tablename
     * @return
     * @throws YosException
     */
    public boolean isSiteTable(String tablename) throws YosException {
        if (siteTableMap.containsKey(tablename)) {
            return siteTableMap.get(tablename);
        }
        boolean issiteid = getTableColumns(tablename).containsKey("siteid");
        siteTableMap.put(tablename, issiteid);
        return issiteid;
    }


    /**
     * 获取指定表的字段信息
     *
     * @param tablename
     * @return
     */
    public String getTableName(String tablename) throws YosException {
        tablename = tablename.toLowerCase();
        Rows rows = dbConnect.runSqlQuery("select table_comment from sys_object where table_name='" + tablename + "'");
        return rows.isEmpty() ? "" : rows.get(0).getString("table_comment");
    }

    /**
     * 获取指定账号登陆时间
     *
     * @return
     */
    public Date getLoginDate(long usersiteid) {
        return parameter.loginDate.getOrDefault(usersiteid, getDateTime());
    }


    /**
     * 获取分类明细描述信息
     *
     * @param typename 分类名称
     * @return
     */
    public HashMap<String, String> getOptionType(String typename) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select t2.value,t2.remarks from sys_optiontype t1 inner join sys_optiontypemx t2 on t1.optiontypeid = t2.optiontypeid where t1.typename='" + typename + "'");
        HashMap<String, String> map = new HashMap<>();
        for (Row row : rows) {
            map.put(row.getString("value"), row.getString("remarks"));
        }
        return map;
    }


    /**
     * 使指定账户登出
     *
     * @param userid
     */
    public void loguserout(long userid) throws YosException {
        ArrayList<String> usersiteids = dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid=" + userid).toArrayList("usersiteid");
        for (String id : usersiteids) {
            long usersiteid = Long.parseLong(id);
            if (usersiteIdList.containsKey(usersiteid)) {
                String token = usersiteIdList.get(usersiteid).getString("token");
                parameter.tokenlist.remove(token);
                SQLProcess.cleanPool(token);
                QuerySQL.cleanDataLimitRowsMapPool(token);
            }
        }
        dbConnect.runSqlUpdate("update sys_usersite set accesstoken=null,systemclient=null where userid='" + userid + "'");
    }


    /**
     * 使指定角色的账户登出
     *
     * @param roleid
     */
    public void logroleout(long roleid, Long excludeuserid) throws YosException {
        ArrayList<String> useridlist = dbConnect.runSqlQuery("select userid from sys_userrole where roleid=" + roleid).toArrayList("userid");
        for (String id : useridlist) {
            if (!id.equals(String.valueOf(excludeuserid))) {
                loguserout(Long.parseLong(id));
            }
        }
    }


    /**
     * 生成一个指定位数的字符串，位数不满足的前置由0填充
     *
     * @param length
     * @param num
     * @return
     */
    public String makeFillCode(int length, long num) {
        String code = "";
        String num_str = String.valueOf(num);
        if (length - num_str.length() > 0) {
            code = String.format("%0" + (length) + "d", Integer.valueOf(num_str));
        } else {
            code = num_str;
        }
        return code;
    }

    /**
     * 生成一个指定位数的字符串，位数不满足的前置由0填充
     *
     * @param length
     * @param num
     * @return
     */
    public String makeFillCode(int length, int num) {
        return makeFillCode(length, Long.valueOf(num));
    }

    /**
     * 根据userid获取组织人员信息
     *
     * @param userid
     * @return
     */
    public Row getHr(long userid, String siteid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select  * from sys_hr where siteid='" + siteid + "' and userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    /**
     * 根据userid获取所属部门信息
     *
     * @param userid
     * @return
     */
    public Row getDepartment(long userid, String siteid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select  t2.* from sys_hr t1 inner join sys_department t2 on t1.siteid=t2.siteid and t1.departmentid=t2.departmentid where t1.siteid='" + siteid + "' and t1.userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    /**
     * 根据userid获取企业档案信息
     *
     * @param userid
     * @return
     */
    public Row getEnterpriseByUserid(long userid, String siteid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select  t2.* from sys_enterprise_hr t1 inner join sys_enterprise t2 on t1.siteid=t2.siteid and t1.sys_enterpriseid=t2.sys_enterpriseid where t1.siteid='" + siteid + "' and t1.userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    /**
     * 根据userid获取商户人员信息
     *
     * @param userid
     * @return
     */
    public Row getEnterpriseHr(long userid, String siteid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select t1.*,t2.accountno from sys_enterprise_hr t1 inner join sys_users t2 on t2.userid = t1.userid where t1.siteid='" + siteid + "' and t1.userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    /**
     * 根据userid获取商户人员信息
     *
     * @param sys_enterpriseid
     * @return
     */
    public Rows getEnterpriseHrs(long sys_enterpriseid, String siteid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select t1.*,t2.accountno from sys_enterprise_hr t1 inner join sys_users t2 on t2.userid = t1.userid where t1.siteid='" + siteid + "' and t1.sys_enterpriseid=" + sys_enterpriseid + " order by t1.isleader desc");
        return rows;
    }


    private static HashMap<Long, ArrayList<Long>> imdialog_usermap = new HashMap<Long, ArrayList<Long>>();

    /**
     * 根据消息对话框ID获取用户id
     *
     * @param timdialogid
     * @return
     */
    public ArrayList<Long> getImDialogUserIds(long timdialogid, String siteid) throws YosException {
        if (!imdialog_usermap.containsKey(timdialogid)) {
            Rows rows = dbConnect.runSqlQuery("select userid from timdialogusers where siteid='" + siteid + "' and timdialogid='" + timdialogid + "' and fisremove=0");
            ArrayList<Long> list = new ArrayList<Long>();
            for (Row row : rows) {
                list.add(row.getLong("userid"));
            }
            imdialog_usermap.put(timdialogid, list);
        }
        return imdialog_usermap.get(timdialogid);
    }


    /**
     * 根据siteid及userid获取usersiteid
     * @param userid
     * @param siteid
     * @return
     */
    public long getUserSiteId(long userid, String siteid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select usersiteid from sys_usersite where siteid='" + siteid + "' and userid=" + userid);
        if (rows.isNotEmpty()) {
            return rows.get(0).getLong("usersiteid");
        } else {
            return 0L;
        }
    }


    /**
     * 将指定的数组value前后倒转
     * @param t
     * @param <T>
     * @return
     */
    public <T> T[] array_Invert(T[] t) {
        int length = t.length;
        Object[] os = new Object[length];
        for (int i = 0; i < length; i++) {
            os[i] = t[i];
        }
        for (Object o : os) {
            t[--length] = (T) o;
        }
        return t;
    }

    /**
     * 生成一个唯一的流水码作为云存储文件名称
     *
     * @return
     * @throws IOException
     */
    public String createMD5FileName() {
        String date_str;
        Date date = new Date();
        date_str = (new SimpleDateFormat("yyyyMMdd")).format(date);
        long time = date.getTime();
        int random = java.lang.Math.abs((new Random()).nextInt() % 1000);
        String var3 = null;
        try {
            var3 = MessageDigest.getInstance("MD5").digest(String.valueOf(random).getBytes()).toString().replaceAll("[^a-z^A-Z^0-9]", "");
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return date_str + time + var3;
    }


    /**
     * 将汉字转换为拼音
     * @param chinese 汉字内容
     * @param isfirstchar 是否只需拼音首字母
     * @param hanyuPinyinCaseType 大小写类型
     * @return
     */
    public String getPinYin(String chinese, boolean isfirstchar, HanyuPinyinCaseType hanyuPinyinCaseType) {
        return GetPinYin.Get(chinese, isfirstchar, hanyuPinyinCaseType);
    }

    /**
     * 校验身份证号是否有效
     * @param idcardno
     * @return
     */
    public boolean idCard_validate(String idcardno) {
        int[] PARITYBIT = {'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] POWER_LIST = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        if (idcardno == null || (idcardno.length() != 15 && idcardno.length() != 18)) {
            return false;
        }
        final char[] cs = idcardno.toUpperCase().toCharArray();
        // 校验位数
        int power = 0;
        for (int i = 0; i < cs.length; i++) {
            if (i == cs.length - 1 && cs[i] == 'X') {
                break;// 最后一位可以 是X或x
            }
            if (cs[i] < '0' || cs[i] > '9') {
                return false;
            }
            if (i < cs.length - 1) {
                power += (cs[i] - '0') * POWER_LIST[i];
            }
        }
        // 校验"校验码"
        if (idcardno.length() == 15) {
            return true;
        }
        return cs[cs.length - 1] == PARITYBIT[power % 11];
    }

    /**
     * 创建一个单据编号
     * @return
     */
    public String createBillCode(String siteid, String coderuletype) throws YosException {
        synchronized (BaseClass.class) {
            SQLFactory sitecoderulesquerySQl = new SQLFactory("站点编码规则查询");
            sitecoderulesquerySQl.addParameter("siteid", siteid);
            sitecoderulesquerySQl.addParameter("coderuletype", coderuletype);

            Rows sitecoderules = dbConnect.runSqlQuery(sitecoderulesquerySQl.getSQL());
            if (sitecoderules.isEmpty()) {
            /*
            如果找不到站点编码规则，则查询系统默认编码规则并将生成站点编码规则
             */
                SQLFactory sitecoderulequerySQl = new SQLFactory("编码规则查询");
                sitecoderulequerySQl.addParameter("coderuletype", coderuletype);
                Rows coderule = dbConnect.runSqlQuery(sitecoderulequerySQl.getSQL());
                if (coderule.size() != 1) {
                    throw new YosException("编码规则查询错误！");
                }
                SQLFactory sitecoderulesinsertSQl = new SQLFactory("站点编码规则插入");
                sitecoderulesinsertSQl.addParameter("siteid", siteid);
                sitecoderulesinsertSQl.addParameter("sys_coderuleid", coderule.get(0).getLong("sys_coderuleid"));
                sitecoderulesinsertSQl.addParameter("sys_coderulesid", createTableID("sys_coderules"));
                sitecoderulesinsertSQl.addParameter("fixed", coderule.get(0).getString("fixed"));
                sitecoderulesinsertSQl.addParameter("numlength", coderule.get(0).getInteger("numlength"));
                sitecoderulesinsertSQl.addParameter("numincludetime", coderule.get(0).getInteger("numincludetime"));
                sitecoderulesinsertSQl.addParameter("timeformat", coderule.get(0).getString("timeformat"));
                dbConnect.runSqlUpdate(sitecoderulesinsertSQl.getSQL());
                sitecoderules = dbConnect.runSqlQuery(sitecoderulesquerySQl.getSQL());
            }
            if (sitecoderules.size() != 1) {
                throw new YosException("编码规则查询错误！");
            }

            String billcode;
            long sys_coderulesid = sitecoderules.get(0).getLong("sys_coderulesid");
            String fixed = sitecoderules.get(0).getString("fixed");
            int numlength = sitecoderules.get(0).getInteger("numlength");
            boolean numincludetime = sitecoderules.get(0).getBoolean("numincludetime");

            if (numincludetime) {
                String timeformat = sitecoderules.get(0).getString("timeformat");
                String timestr = new SimpleDateFormat(timeformat).format(Calendar.getInstance().getTime());
                long serialnum;
                long sys_coderules_timeserialnumid;
                Rows timeserialnumsRows = dbConnect.runSqlQuery("select sys_coderules_timeserialnumid,serialnum from sys_coderules_timeserialnum where siteid='" + siteid + "' and sys_coderulesid='" + sys_coderulesid + "' and timestr='" + timestr + "'");
                if (timeserialnumsRows.isEmpty()) {
                    sys_coderules_timeserialnumid = createTableID("sys_coderules_timeserialnum");
                    SQLFactory sitecoderulestimeinsertSQl = new SQLFactory("站点编码规则时间序号表插入");
                    sitecoderulestimeinsertSQl.addParameter("siteid", siteid);
                    sitecoderulestimeinsertSQl.addParameter("sys_coderulesid", sys_coderulesid);
                    sitecoderulestimeinsertSQl.addParameter("sys_coderules_timeserialnumid", sys_coderules_timeserialnumid);
                    sitecoderulestimeinsertSQl.addParameter("timestr", timestr);
                    dbConnect.runSqlUpdate(sitecoderulestimeinsertSQl.getSQL());
                    serialnum = 0L;
                } else {
                    sys_coderules_timeserialnumid = timeserialnumsRows.get(0).getLong("sys_coderules_timeserialnumid");
                    serialnum = timeserialnumsRows.get(0).getLong("serialnum");
                }
                serialnum = serialnum + 1L;
                billcode = fixed + timestr + makeFillCode(numlength - timestr.length(), serialnum);
                dbConnect.runSqlUpdate("update sys_coderules_timeserialnum set serialnum=" + serialnum + " where sys_coderules_timeserialnumid=" + sys_coderules_timeserialnumid);
            } else {
                long serialnum = sitecoderules.get(0).getLong("serialnum");
                serialnum = serialnum + 1;
                billcode = fixed + makeFillCode(numlength, serialnum);
                dbConnect.runSqlUpdate("update sys_coderules set serialnum=" + serialnum + " where sys_coderulesid=" + sys_coderulesid);
            }
            return billcode;
        }
    }

    /**
     * 获取SQL中的参数信息
     * @param sql
     * @return
     */
    public ArrayList<String> getSQLParams(String sql) {
        ArrayList<String> paramsList = new ArrayList<>();
        StringBuilder param = new StringBuilder();
        boolean paramstart = false;
        for (char b : sql.toCharArray()) {
            if (b == '$' && !paramstart) {
                paramstart = true;
            } else if (b != '$' && paramstart) {
                param.append(b);
            } else if (b == '$' && paramstart) {
                paramstart = false;
                paramsList.add(param.toString());
                param = new StringBuilder();
            }
        }
        return paramsList;
    }
}
