/*
 * Decompiled with CFR 0.152.
 */
package utility.huawei.obs;

import beans.parameter.Parameter;
import com.huaweicloud.sdk.ces.v1.CesClient;
import com.huaweicloud.sdk.ces.v1.model.Datapoint;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataRequest;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataResponse;
import com.huaweicloud.sdk.ces.v1.region.CesRegion;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BucketCESManage
extends BaseClass {
    protected String bucketname;
    protected CesClient cesClient;
    protected ArrayList<String> sqllist1;
    protected ArrayList<String> sqllist2;
    protected long fromtime;
    protected long totime;
    protected String yeaterday;

    private String getBucketname(String siteid) {
        try {
            Rows rows = this.dbConnect.runSqlQuery("select bucketname from sys_site where siteid='" + siteid + "'");
            if (rows.isNotEmpty()) {
                this.bucketname = rows.get(0).getString("bucketname").toLowerCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.bucketname;
    }

    public BucketCESManage(String siteid) throws YosException {
        this.bucketname = this.getBucketname(siteid);
        AbstractCredentials auth = ((BasicCredentials)new BasicCredentials().withAk(Parameter.get("attachment_huawei_obs_ak"))).withSk(Parameter.get("attachment_huawei_obs_sk"));
        this.cesClient = (CesClient)CesClient.newBuilder().withCredential((ICredential)auth).withRegion(CesRegion.valueOf((String)Parameter.get("attachment_huawei_obs_location"))).build();
        this.sqllist1 = new ArrayList();
        this.sqllist2 = new ArrayList();
    }

    public void getData() throws YosException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.yeaterday = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select * from sys_obsdatalog where siteid='" + this.bucketname + "' and createdate='" + this.yeaterday + "'");
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.fromtime = calendar.getTimeInMillis();
        calendar.add(5, 1);
        this.totime = calendar.getTimeInMillis();
        if (rows.size() < 6) {
            this.getDownload_traffic();
            if (!this.sqllist1.isEmpty()) {
                dbConnect.runSqlUpdate(this.sqllist1);
            }
            this.getUpload_traffic();
            if (!this.sqllist2.isEmpty()) {
                dbConnect.runSqlUpdate(this.sqllist2);
            }
        }
    }

    private void getDownload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("download_traffic");
        request.withDim0("bucket_name," + this.bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue((String)"sum"));
        request.withPeriod(Integer.valueOf(14400));
        request.withFrom(Long.valueOf(this.fromtime));
        request.withTo(Long.valueOf(this.totime));
        try {
            ShowMetricDataResponse response = this.cesClient.showMetricData(request);
            List list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double downloadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();
                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);
                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());
                    SQLFactory factory1 = new SQLFactory(this, "\u6570\u636e\u6d41\u51fa\u91cf\u65e5\u5fd7\u66f4\u65b01");
                    factory1.addParameter("siteid", this.bucketname.toUpperCase());
                    factory1.addParameter("sys_obsdatalogid", this.createTableID("sys_obsdatalog"));
                    factory1.addParameter("timestamp", time);
                    factory1.addParameter("createdate", createdate);
                    factory1.addParameter("createtime", createtime);
                    SQLFactory factory2 = new SQLFactory(this, "\u6570\u636e\u6d41\u51fa\u91cf\u65e5\u5fd7\u66f4\u65b02");
                    factory2.addParameter("downloadbytes", downloadbytes);
                    factory2.addParameter("siteid", this.bucketname.toUpperCase());
                    factory2.addParameter("timestamp", time);
                    this.sqllist1.add(factory1.getSQL());
                    this.sqllist1.add(factory2.getSQL());
                }
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }

    public static void main(String[] args) throws YosException {
        BucketCESManage bucketCESManage = new BucketCESManage("DSB01");
        bucketCESManage.getDownload_traffic();
    }

    private void getUpload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("upload_traffic");
        request.withDim0("bucket_name," + this.bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue((String)"sum"));
        request.withPeriod(Integer.valueOf(14400));
        request.withFrom(Long.valueOf(this.fromtime));
        request.withTo(Long.valueOf(this.totime));
        try {
            ShowMetricDataResponse response = this.cesClient.showMetricData(request);
            List list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double uploadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();
                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);
                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());
                    SQLFactory factory1 = new SQLFactory(this, "\u6570\u636e\u4e0a\u4f20\u91cf\u65e5\u5fd7\u66f4\u65b01");
                    factory1.addParameter("sys_obsdatalogid", this.createTableID("sys_obsdatalog"));
                    factory1.addParameter("siteid", this.bucketname.toUpperCase());
                    factory1.addParameter("timestamp", time);
                    factory1.addParameter("createdate", createdate);
                    factory1.addParameter("createtime", createtime);
                    SQLFactory factory2 = new SQLFactory(this, "\u6570\u636e\u4e0a\u4f20\u91cf\u65e5\u5fd7\u66f4\u65b02");
                    factory2.addParameter("uploadbytes", uploadbytes);
                    factory2.addParameter("siteid", this.bucketname.toUpperCase());
                    factory2.addParameter("timestamp", time);
                    this.sqllist2.add(factory1.getSQL());
                    this.sqllist2.add(factory2.getSQL());
                }
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }
}

