/*
 * Decompiled with CFR 0.152.
 */
package utility.huawei.obs;

import beans.parameter.Parameter;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCorsRule;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.ObsBucket;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import java.util.ArrayList;
import utility.tools.Math;

public class Bucket
extends BaseClass {
    protected String bucketname;
    protected String siteid;
    protected ObsClient obsClient;

    public static void main(String[] args) throws YosException {
        Bucket bucket = new Bucket("YOSSYS");
        bucket.createBucketname();
    }

    public Bucket(String siteid) throws YosException {
        this.siteid = siteid.toLowerCase();
        this.obsClient = new ObsClient(Parameter.get("attachment_huawei_obs_ak"), Parameter.get("attachment_huawei_obs_sk"), Parameter.get("attachment_huawei_obs_endpoint"));
        this.bucketname = this.getBucketname();
        if (!this.isAllReadyUsed()) {
            this.create();
        }
    }

    private String getBucketname() {
        try {
            Rows rows = this.dbConnect.runSqlQuery("select bucketname from sys_site where ifnull(bucketname,'')!='' and siteid='" + this.siteid + "'");
            if (rows.isNotEmpty()) {
                this.bucketname = rows.get(0).getString("bucketname").toLowerCase();
            } else {
                this.bucketname = this.createBucketname().toLowerCase();
                this.dbConnect.runSqlUpdate("update sys_site set bucketname='" + this.bucketname + "' where siteid='" + this.siteid + "'");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.bucketname;
    }

    private String createBucketname() {
        String bn = (this.siteid + Math.random(5)).toLowerCase();
        if (this.obsClient.headBucket(bn)) {
            return this.createBucketname();
        }
        return bn;
    }

    public ObsClient getObsClient() {
        return this.obsClient;
    }

    public boolean create() throws YosException {
        try {
            ObsBucket obsBucket = new ObsBucket();
            obsBucket.setBucketName(this.bucketname);
            obsBucket.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ_WRITE);
            obsBucket.setLocation(Parameter.get("attachment_huawei_obs_location"));
            this.obsClient.createBucket(obsBucket);
            this.setBucketCors();
        }
        catch (ObsException e) {
            System.out.println("HTTP Code: " + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Error Message: " + e.getErrorMessage());
            System.out.println("Request ID:" + e.getErrorRequestId());
            System.out.println("Host ID:" + e.getErrorHostId());
            return false;
        }
        return true;
    }

    public void setBucketCors() {
        BucketCors cors = new BucketCors();
        ArrayList<BucketCorsRule> rules = new ArrayList<BucketCorsRule>();
        BucketCorsRule rule = new BucketCorsRule();
        ArrayList<String> allowedOrigin = new ArrayList<String>();
        allowedOrigin.add("*");
        rule.setAllowedOrigin(allowedOrigin);
        ArrayList<String> allowedMethod = new ArrayList<String>();
        allowedMethod.add("GET");
        allowedMethod.add("HEAD");
        allowedMethod.add("PUT");
        allowedMethod.add("POST");
        allowedMethod.add("DELETE");
        rule.setAllowedMethod(allowedMethod);
        ArrayList<String> allowedHeader = new ArrayList<String>();
        allowedHeader.add("*");
        rule.setAllowedHeader(allowedHeader);
        rule.setMaxAgeSecond(3600);
        rules.add(rule);
        cors.setRules(rules);
        this.obsClient.setBucketCors(this.bucketname, cors);
        String policy = "{\n    \"Statement\": [\n        {\n            \"Sid\": \"\u516c\u5171\u8bfb\",\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"ID\": [\n                    \"*\"\n                ]\n            },\n            \"Action\": [\n                \"ListBucket\",\n                \"HeadBucket\",\n                \"GetBucketLocation\",\n                \"ListBucketVersions\",\n                \"GetObject\",\n                \"RestoreObject\",\n                \"GetObjectVersion\"\n            ],\n            \"Resource\": [\n                \"" + this.bucketname + "\",\n                \"" + this.bucketname + "/*\"\n            ]\n        }\n    ]\n}";
        this.obsClient.setBucketPolicy(this.bucketname, policy);
    }

    public boolean isAllReadyUsed() {
        return this.obsClient.headBucket(this.bucketname);
    }

    public void delete() {
        this.obsClient.deleteBucket(this.bucketname);
    }

    public void setVolume(long volume) {
        BucketQuota quota = new BucketQuota(0x40000000L * volume);
        this.obsClient.setBucketQuota(this.bucketname, quota);
    }

    public long getMaxVolume() {
        BucketQuota quota = this.obsClient.getBucketQuota(this.bucketname);
        return quota.getBucketQuota();
    }

    public long getVolume() {
        BucketStorageInfo storageInfo = this.obsClient.getBucketStorageInfo(this.bucketname);
        return storageInfo.getSize();
    }

    public long getFileCount() {
        BucketStorageInfo storageInfo = this.obsClient.getBucketStorageInfo(this.bucketname);
        return storageInfo.getObjectNumber();
    }
}

