/*
 * Decompiled with CFR 0.152.
 */
package utility.bankdocking.ccb;

import beans.parameter.Parameter;
import common.YosException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlFactory {
    public String createGetBankDataXml(String siteid, int STARTDATE, int ENDDATE, int PAGE) throws YosException {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("GB2312");
        Element root = DocumentHelper.createElement((String)"TX");
        root.addElement("REQUEST_SN").setText(String.valueOf(Calendar.getInstance().getTimeInMillis()));
        root.addElement("CUST_ID").setText(Parameter.get(siteid, "bank_ccb_cust_id"));
        root.addElement("USER_ID").setText(Parameter.get(siteid, "bank_ccb_user_id"));
        root.addElement("PASSWORD").setText(Parameter.get(siteid, "bank_ccb_password"));
        root.addElement("TX_CODE").setText("6WY101");
        root.addElement("LANGUAGE").setText("CN");
        Element TX_INFO = root.addElement("TX_INFO");
        TX_INFO.addElement("ACCNO1").setText(Parameter.get(siteid, "bank_ccb_accno"));
        TX_INFO.addElement("STARTDATE").setText(String.valueOf(STARTDATE));
        TX_INFO.addElement("ENDDATE").setText(String.valueOf(ENDDATE));
        TX_INFO.addElement("BARGAIN_FLAG").setText("1");
        TX_INFO.addElement("CHECK_ACC_NO").setText("");
        TX_INFO.addElement("CHECK_ACC_NAME").setText("");
        TX_INFO.addElement("REMARK").setText("");
        TX_INFO.addElement("LOW_AMT").setText("");
        TX_INFO.addElement("HIGH_AMT").setText("");
        TX_INFO.addElement("PAGE").setText(String.valueOf(PAGE));
        TX_INFO.addElement("POSTSTR").setText("");
        TX_INFO.addElement("TOTAL_RECORD").setText("200");
        TX_INFO.addElement("DET_NO").setText("");
        TX_INFO.addElement("END_NO").setText("");
        document.setRootElement(root);
        String xml = document.asXML();
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"GB2312\"?>", "<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\"?>");
        return xml;
    }

    public String getReturnCode(String xml) {
        String RETURN_CODE = "";
        try {
            Document document = DocumentHelper.parseText((String)xml);
            RETURN_CODE = document.getRootElement().element("RETURN_CODE").getText();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return RETURN_CODE;
    }

    public boolean getListByXml(ArrayList<HashMap<String, String>> arraylist, String xml) {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element tx_infoelement = document.getRootElement().element("TX_INFO");
            String ACCNO1 = tx_infoelement.element("ACCNO1").getText();
            Element element = tx_infoelement.element("DETAILLIST");
            List infolist = element.elements("DETAILINFO");
            if (infolist.size() == 0) {
                return false;
            }
            for (Element e : infolist) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TRANDATE", e.element("TRANDATE").getText());
                map.put("TRANTIME", e.element("TRANTIME").getText());
                map.put("CRE_TYP", e.element("CRE_TYP").getText());
                map.put("CRE_NO", e.element("CRE_NO").getText());
                map.put("MESSAGE", e.element("MESSAGE").getText());
                map.put("AMT", e.element("AMT").getText());
                map.put("AMT1", e.element("AMT1").getText());
                map.put("FLAG1", e.element("FLAG1").getText());
                map.put("ACCNO2", e.element("ACCNO2").getText());
                map.put("ACC_NAME1", e.element("ACC_NAME1").getText());
                map.put("FLAG2", e.element("FLAG2").getText());
                map.put("TRAN_FLOW", e.element("TRAN_FLOW").getText());
                map.put("BFLOW", e.element("BFLOW").getText());
                map.put("DET_NO", e.element("DET_NO").getText());
                map.put("DET", e.element("DET").getText());
                map.put("REAL_TRANDATE", e.element("REAL_TRANDATE").getText());
                map.put("RLTV_ACCNO", e.element("RLTV_ACCNO").getText());
                map.put("CADBank_Nm", e.element("CADBank_Nm").getText());
                map.put("Ovrlsttn_Trck_No", e.element("Ovrlsttn_Trck_No").getText());
                map.put("ExoStm_Py_Rmrk", e.element("ExoStm_Py_Rmrk").getText());
                map.put("ACCNO1", ACCNO1);
                arraylist.add(map);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

