/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.apimanage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.parameter.parameter;
import java.util.HashMap;

@API(title="\u7ba1\u7406\u7aef-\u5f00\u53d1-API\u63a5\u53e3\u76d1\u63a7")
public class ApiMonitor
extends Controller {
    public ApiMonitor(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u63a5\u53e3\u4fe1\u606f\u67e5\u8be2")
    @CACHEING(life=1)
    public String queryApiList() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where")) {
            JSONObject whereObject = this.content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.classname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.method like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.apiid ='").append(whereObject.getString("condition")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("iscacheing") && !"".equals(whereObject.getString("iscacheing"))) {
                where.append(" and(");
                where.append("t2.iscacheing ='").append(whereObject.getString("iscacheing")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("accesstoken") && !"".equals(whereObject.getString("accesstoken"))) {
                where.append(" and(");
                where.append("t2.accesstoken ='").append(whereObject.getString("accesstoken")).append("' ");
                where.append(")");
            }
        }
        Rows methodrows = null;
        if (this.content.getBooleanValue("simple")) {
            methodrows = this.content.getBooleanValue("apiwithid") ? SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where t2.apiid!='' and " + where + " order by t1.classname,t2.method") : SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by t1.classname,t2.method");
        } else {
            String key;
            Rows methodrows_count = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where);
            for (Row row : methodrows_count) {
                key = "restcontroller." + row.getString("classname") + "." + row.getString("method");
                long requesttimes = parameter.callmethodTimes.getOrDefault(key, 0L);
                String lastrequesttime = "";
                if (parameter.lastcallmethodtime.containsKey(key)) {
                    lastrequesttime = this.getDateTime_Str(parameter.lastcallmethodtime.get(key));
                }
                long requesttimelong_avg = parameter.callmethodTimeLong.getOrDefault(key, 0L);
                SQLiteMemory.runSqlUpdate("update apimethod set requesttimes=" + requesttimes + ",lastrequesttime='" + lastrequesttime + "',requesttimelong_avg=" + requesttimelong_avg + " where  classname='" + row.getString("classname") + "' and method='" + row.getString("method") + "'");
            }
            this.pageSorting = this.pageSorting.equals("''") ? "t1.classname,t2.method" : this.pageSorting;
            methodrows = SQLiteMemory.runSqlQuery("select distinct t1.classname,t1.title as classtitle,t1.notes as classnotes,t2.method,t2.title,t2.notes,t2.cacheinglife,t2.iscacheing,t2.iscacheingclean,t2.cleandatas,t2.intervaltime,t2.accesstoken,t2.apiid,t2.apiversion,t2.deprecated,t2.requesttimes,t2.lastrequesttime,t2.requesttimelong_avg from apiclass t1 inner join apimethod t2 on t1.classname=t2.classname where" + where + " order by " + this.pageSorting + " LIMIT " + this.pageSize + " OFFSET " + this.pageSize * (this.pageNumber - 1));
            methodrows.totalPage = new Double(Math.ceil((double)methodrows_count.size() / (double)this.pageSize)).longValue();
            methodrows.totalRows = methodrows_count.size();
            for (Row methodrow : methodrows) {
                key = "restcontroller." + methodrow.getString("classname") + "." + methodrow.getString("method");
                JSONObject requestmsg = new JSONObject(true);
                requestmsg.put("requesttimes", (Object)parameter.callmethodTimes.getOrDefault(key, 0L));
                requestmsg.put("readcachetimes", (Object)parameter.callmethod_fromcacheTimes.getOrDefault(key, 0L));
                if (parameter.lastcallmethodtime.containsKey(key)) {
                    requestmsg.put("lastrequesttime", (Object)this.getDateTime_Str(parameter.lastcallmethodtime.get(key)));
                } else {
                    requestmsg.put("lastrequesttime", (Object)"");
                }
                requestmsg.put("requesttimelong_last", (Object)parameter.callmethodLastTimeLong.getOrDefault(key, 0L));
                requestmsg.put("requesttimelong_avg", (Object)parameter.callmethodTimeLong.getOrDefault(key, 0L));
                methodrow.put("requestmsg", requestmsg);
                methodrow.put("cleandatas", JSON.parseArray((String)methodrow.getString("cleandatas")));
            }
        }
        Rows approws = this.dbConnect.runSqlQuery("select t1.apiid,t1.apiversion,t2.systemappname from sys_apiapps t1 inner join sys_systemapp t2 on t1.systemappid=t2.systemappid");
        RowsMap appidrowsMap = approws.toRowsMap("apiid");
        HashMap<String, String> codermap = this.getOptionType("coder");
        for (Row row : methodrows) {
            RowsMap apiversionMap;
            row.put("apps", new JSONArray());
            String apiid = row.getString("apiid");
            String apiversion = row.getString("apiversion");
            if (appidrowsMap.containsKey(apiid) && (apiversionMap = appidrowsMap.get(apiid).toRowsMap("apiversion")).containsKey(apiversion)) {
                row.put("apps", apiversionMap.get(apiversion).toJsonArray("systemappname"));
            }
            if (apiid != null && !apiid.equals("")) {
                row.put("coder", codermap.getOrDefault(apiid.substring(apiid.length() - 2), ""));
                continue;
            }
            row.put("coder", "");
        }
        return this.getSucReturnObject().setData(methodrows).toString();
    }

    @API(title="\u63a5\u53e3\u8bf7\u6c42\u65e5\u5fd7\u67e5\u8be2")
    public String queryApiRequestLog() throws YosException {
        String classname = this.content.getString("classname");
        classname = classname.replace("restcontroller.", "");
        String method = this.content.getString("method");
        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestlog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select requestlogid,createdate,request,usermsg,iscacheing from apirequestlog where classname='" + classname + "' and method='" + method + "' order by createdate desc");
            for (Row row : rows) {
                row.put("request", JSONObject.parseObject((String)row.getString("request")));
                row.put("usermsg", JSONObject.parseObject((String)row.getString("usermsg")));
            }
            return this.getSucReturnObject().setData(rows).toString();
        }
        return this.getSucReturnObject().setData(new Rows()).toString();
    }

    @API(title="\u63a5\u53e3\u8bf7\u6c42SQL\u65e5\u5fd7\u67e5\u8be2")
    public String queryApiRequestSQLLog() throws YosException {
        String requestlogid = this.content.getString("requestlogid");
        SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestsqllog");
        if (!sqLiteTable.dosNotExist()) {
            Rows rows = SQLiteMemory.runSqlQuery("select sql,runtime,success,errmsg from apirequestsqllog where requestlogid='" + requestlogid + "' order by createtimeinmillis");
            return this.getSucReturnObject().setData(rows).toString();
        }
        return this.getSucReturnObject().setData(new Rows()).toString();
    }
}

