/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import com.alibaba.fastjson.JSONArray;
import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class SQLiteMemory {
    private static Connection conn = null;

    private static void createConnect() {
        if (conn == null) {
            try {
                Class.forName("org.sqlite.JDBC");
                conn = DriverManager.getConnection("jdbc:sqlite::memory:");
                conn.setAutoCommit(false);
            }
            catch (Exception e) {
                System.err.println("sqlite\u7f13\u5b58\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
            }
        }
    }

    public static void runSqlUpdate(String SQL) {
        SQLiteMemory.createConnect();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(SQL);
            statement.executeUpdate();
            conn.commit();
        }
        catch (Exception e) {
            System.err.println("sqlite\u7f13\u5b58\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25:" + SQL + System.lineSeparator() + e.getMessage());
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSqlUpdate(ArrayList<String> SQLlist) {
        SQLiteMemory.createConnect();
        Statement statement = null;
        try {
            for (String sql : SQLlist) {
                statement = conn.prepareStatement(sql);
                statement.executeUpdate();
            }
            conn.commit();
        }
        catch (Exception e) {
            System.err.println("sqlite\u7f13\u5b58\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25:" + JSONArray.toJSON(SQLlist) + System.lineSeparator() + e.getMessage());
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rows runSqlQuery(String SQL) {
        SQLiteMemory.createConnect();
        Rows rows = new Rows();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            ArrayList<String> colNameList = new ArrayList<String>();
            ArrayList<String> colTypeList = new ArrayList<String>();
            for (int i = 0; i < colCount; ++i) {
                colNameList.add(rsmd.getColumnName(i + 1));
                colTypeList.add(rsmd.getColumnTypeName(i + 1));
            }
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; ++i) {
                    Object value;
                    String type;
                    String key = (String)colNameList.get(i);
                    switch (type = ((String)colTypeList.get(i)).toLowerCase()) {
                        case "int": {
                            value = resultSet.getInt((String)colNameList.get(i));
                            break;
                        }
                        case "bigint": {
                            value = resultSet.getLong((String)colNameList.get(i));
                            break;
                        }
                        case "smallint": {
                            value = resultSet.getShort((String)colNameList.get(i));
                            break;
                        }
                        case "float": 
                        case "numeric": 
                        case "decimal": {
                            value = resultSet.getBigDecimal((String)colNameList.get(i));
                            break;
                        }
                        case "datetime": {
                            value = resultSet.getString((String)colNameList.get(i));
                            if (value == null) break;
                            value = ((String)value).replace(" 00:00:00.0", "");
                            break;
                        }
                        default: {
                            value = resultSet.getString((String)colNameList.get(i));
                        }
                    }
                    if ("total".equals(key)) {
                        rows.totalRows = (Long)value;
                        continue;
                    }
                    if ("pageTotal".equals(key)) {
                        rows.totalPage = ((BigDecimal)value).longValue();
                        continue;
                    }
                    row.put(key, value);
                }
                rows.add(row);
            }
        }
        catch (Exception e) {
            System.err.println("sqlite\u7f13\u5b58\u6570\u636e\u5e93\u6267\u884c\u67e5\u8be2\u5931\u8d25:" + SQL + System.lineSeparator() + e.getMessage());
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rows runSqlQueryWithFieldMeta(String SQL) {
        SQLiteMemory.createConnect();
        Rows rows = new Rows();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            ArrayList<String> colNameList = new ArrayList<String>();
            ArrayList<String> colTypeList = new ArrayList<String>();
            HashMap<String, FieldMeta> getFieldMetaMap = new HashMap<String, FieldMeta>();
            for (int i = 0; i < colCount; ++i) {
                colNameList.add(rsmd.getColumnName(i + 1));
                colTypeList.add(rsmd.getColumnTypeName(i + 1));
            }
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; ++i) {
                    Object value;
                    String type;
                    FieldMeta fieldmeta = new FieldMeta();
                    fieldmeta.setTable_name(rsmd.getTableName(i + 1));
                    fieldmeta.setColumn_name(rsmd.getColumnName(i + 1));
                    fieldmeta.setPrecision(rsmd.getPrecision(i + 1));
                    fieldmeta.setScale(rsmd.getScale(i + 1));
                    String Columnlabel = rsmd.getColumnLabel(i + 1);
                    fieldmeta.setColumn_lable(Columnlabel);
                    String key = colNameList.get(i);
                    switch (type = ((String)colTypeList.get(i)).toLowerCase()) {
                        case "int": {
                            value = resultSet.getInt(colNameList.get(i));
                            fieldmeta.setFieldtype(Integer.class);
                            break;
                        }
                        case "bigint": {
                            value = resultSet.getLong(colNameList.get(i));
                            fieldmeta.setFieldtype(Long.class);
                            break;
                        }
                        case "smallint": {
                            value = resultSet.getShort(colNameList.get(i));
                            fieldmeta.setFieldtype(Integer.class);
                            break;
                        }
                        case "float": 
                        case "numeric": 
                        case "decimal": {
                            value = resultSet.getBigDecimal(colNameList.get(i));
                            fieldmeta.setFieldtype(BigDecimal.class);
                            break;
                        }
                        case "datetime": {
                            value = resultSet.getString(colNameList.get(i));
                            if (value != null) {
                                value = ((String)value).replace(" 00:00:00.0", "");
                            }
                            fieldmeta.setFieldtype(Date.class);
                            break;
                        }
                        default: {
                            value = resultSet.getString(colNameList.get(i));
                            fieldmeta.setFieldtype(String.class);
                        }
                    }
                    if ("total".equals(key)) {
                        rows.totalRows = (Long)value;
                    } else if ("pageTotal".equals(key)) {
                        rows.totalPage = ((BigDecimal)value).longValue();
                    } else {
                        row.put(key, value);
                    }
                    getFieldMetaMap.put(Columnlabel, fieldmeta);
                }
                rows.add(row);
            }
            rows.setFieldList(colNameList);
            rows.setFieldMetaMap(getFieldMetaMap);
        }
        catch (Exception e) {
            System.err.println("sqlite\u7f13\u5b58\u6570\u636e\u5e93\u6267\u884c\u67e5\u8be2\u5931\u8d25:" + SQL + System.lineSeparator() + e.getMessage());
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rows;
    }
}

