/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.system.attachment.huawei;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.obs.services.model.HttpMethodEnum;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import restcontroller.R;
import restcontroller.system.attachment.Attachment;
import utility.huawei.obs.BucketFile;
import utility.huawei.obs.mpc.MediaMetaData;
import utility.huawei.obs.mpc.MpcFactory;

@API(title="\u9644\u4ef6\u7ba1\u7406")
public class OBS
extends Controller {
    public static HashMap<String, HashMap<String, String>> obsfilemap = new HashMap();

    public OBS(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u534e\u4e3a\u4e91\u4e0a\u4f20\u83b7\u53d6obs\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0", apiversion=R.ID10019701.v1.class)
    public String getFileName() {
        JSONObject object = new JSONObject();
        try {
            String filename = this.content.getString("filename");
            String filetype = this.content.getString("filetype");
            String parentid = this.content.getString("parentid");
            HttpMethodEnum HttpMethod = HttpMethodEnum.PUT;
            if (this.content.containsKey("HttpMethod")) {
                if ("post".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                    HttpMethod = HttpMethodEnum.POST;
                } else if ("get".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                    HttpMethod = HttpMethodEnum.GET;
                }
            }
            String serialnumber = this.createMD5FileName() + "." + filetype;
            BucketFile bucketFile = new BucketFile(this.siteid);
            String uploadurl = bucketFile.getUploadUrl(filetype, serialnumber, HttpMethod);
            bucketFile.close();
            object.put("serialfilename", (Object)serialnumber);
            object.put("uploadurl", (Object)uploadurl);
            object.put("filename", (Object)filename);
            object.put("filetype", (Object)filetype);
            object.put("parentid", (Object)parentid);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("filename", filename);
            map.put("filetype", filetype);
            map.put("parentid", parentid);
            obsfilemap.put(serialnumber, map);
        }
        catch (Exception e) {
            return this.getErrReturnObject().setErrMsg(e.getMessage()).toString();
        }
        return this.getSucReturnObject().setData(object).toString();
    }

    @API(title="\u534e\u4e3a\u4e91\u4e0a\u4f20\u6279\u91cf\u83b7\u53d6obs\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0", apiversion=R.ID10019801.v1.class)
    public String getFileNames() throws YosException {
        JSONArray returnarray = new JSONArray();
        JSONArray filesArray = this.content.getJSONArray("files");
        for (int i = 0; i < filesArray.size(); ++i) {
            try {
                JSONObject fileobject = filesArray.getJSONObject(i);
                String filename = fileobject.getString("filename");
                String filetype = fileobject.getString("filetype");
                String parentid = fileobject.getString("parentid");
                HttpMethodEnum HttpMethod = HttpMethodEnum.PUT;
                if (this.content.containsKey("HttpMethod")) {
                    if ("post".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                        HttpMethod = HttpMethodEnum.POST;
                    } else if ("get".equalsIgnoreCase(this.content.getString("HttpMethod"))) {
                        HttpMethod = HttpMethodEnum.GET;
                    }
                }
                String serialnumber = this.createMD5FileName() + "." + filetype;
                BucketFile bucketFile = new BucketFile(this.siteid);
                String url = bucketFile.getUploadUrl(filetype, serialnumber, HttpMethod);
                bucketFile.close();
                JSONObject object = new JSONObject();
                object.put("serialfilename", (Object)serialnumber);
                object.put("uploadurl", (Object)url);
                object.put("filename", (Object)filename);
                object.put("filetype", (Object)filetype);
                object.put("parentid", (Object)parentid);
                returnarray.add((Object)object);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filename", filename);
                map.put("filetype", filetype);
                map.put("parentid", parentid);
                obsfilemap.put(serialnumber, map);
                continue;
            }
            catch (Exception e) {
                return this.getErrReturnObject().setErrMsg(e.getMessage()).toString();
            }
        }
        return this.getSucReturnObject().setData(returnarray).toString();
    }

    @API(title="\u534e\u4e3a\u4e91\u4e0a\u4f20\u6210\u529f\u53cd\u9988", apiversion=R.ID10019901.v1.class)
    public String uploadSuccess() throws YosException {
        String serialfilename = this.content.getString("serialfilename");
        if (!obsfilemap.containsKey(serialfilename)) {
            return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e91\u5b58\u50a8\u6587\u4ef6").toString();
        }
        String filename = obsfilemap.get(serialfilename).get("filename");
        String filetype = obsfilemap.get(serialfilename).get("filetype");
        String parentid = obsfilemap.get(serialfilename).get("parentid");
        filename = filename.replace("'", "");
        JSONArray attachmentidsarray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        try {
            ArrayList<String> SQlist = new ArrayList<String>();
            BucketFile bucketFile = new BucketFile(this.siteid);
            if (!bucketFile.doesObjectExist(serialfilename)) {
                return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e91\u5b58\u50a8\u6587\u4ef6").toString();
            }
            String mpctaskid = "null";
            String thumbnail_serialfilename = this.createMD5FileName() + ".jpg";
            boolean thumbnail_succsed = false;
            if (this.isVideo(filetype)) {
                MpcFactory mpcFactory = new MpcFactory();
                MediaMetaData data = mpcFactory.getMetaData(this.siteid, serialfilename);
                if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
                    if (filetype.equalsIgnoreCase("mp4")) {
                        if (data != null) {
                            long bitrate = data.getBitrate();
                            long size = data.getSize();
                            if (bitrate / 1024L > 5000L || size / 0x100000L > 500L) {
                                mpctaskid = mpcFactory.createTranscodingTask(this.siteid, serialfilename);
                            }
                        }
                    } else if (filetype.equalsIgnoreCase("mov")) {
                        mpctaskid = mpcFactory.createTranscodingTask(this.siteid, serialfilename);
                    }
                }
                if (Parameter.get("attachment_huawei_obs_mpc_createthumbnails").equalsIgnoreCase("true")) {
                    thumbnail_succsed = mpcFactory.createThumbnailsTask(this.siteid, serialfilename, thumbnail_serialfilename, data.getWidth(), data.getHeight(), 1);
                }
            }
            long attachmentid = this.createTableID("sys_attachment");
            attachmentidsarray.add((Object)attachmentid);
            SQLFactory sqlFactory = new SQLFactory(this, "\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
            sqlFactory.addParameter("parentid", parentid.equals("") || parentid.equals("0") ? "null" : parentid);
            sqlFactory.addParameter("attachmentid", attachmentid);
            sqlFactory.addParameter("siteid", this.siteid);
            sqlFactory.addParameter("createby", this.username);
            sqlFactory.addParameter("type", "sourcefile");
            sqlFactory.addParameter("postfix", filetype);
            sqlFactory.addParameter("serialnumber", serialfilename);
            sqlFactory.addParameter("document", filename);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(serialfilename));
            sqlFactory.addParameter("mpctaskid", mpctaskid);
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(serialfilename).getContentLength());
            SQlist.add(sqlFactory.getSQL());
            if (thumbnail_succsed) {
                sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "cover");
                sqlFactory.addParameter("postfix", "jpg");
                sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
                sqlFactory.addParameter("document", thumbnail_serialfilename);
                sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename));
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
            }
            if (this.isImage(filetype)) {
                sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "thumbnail");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", "s_" + serialfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getMinImageUrl(serialfilename));
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("s_" + serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
                sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "compressed");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", "c_" + serialfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getCompressImageUrl(serialfilename));
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("c_" + serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
            }
            bucketFile.close();
            this.dbConnect.runSqlUpdate(SQlist);
            obsfilemap.remove(serialfilename);
            resultObject.put("code", (Object)1);
            resultObject.put("msg", (Object)"\u6210\u529f");
            JSONObject object = new JSONObject();
            object.put("attachmentids", (Object)attachmentidsarray);
            resultObject.put("data", (Object)object);
            if (!"".equals(this.content.getStringValue("ownertable")) && this.content.getLongValue("ownerid") > 0L && !"".equals(this.content.getString("usetype"))) {
                this.content.put("attachmentids", (Object)attachmentidsarray);
                Attachment attachment = new Attachment(this.content);
                attachment.createFileLink();
                resultObject.put("attinfos", (Object)attachment.queryFileLink());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            resultObject.put("code", (Object)0);
            resultObject.put("msg", (Object)exception.getMessage());
        }
        return resultObject.toString();
    }

    @API(title="\u534e\u4e3a\u4e91\u6279\u91cf\u4e0a\u4f20\u6210\u529f\u53cd\u9988", apiversion=R.ID10020001.v1.class)
    public String uploadSuccesses() throws YosException {
        JSONArray obsfilenamesArray = this.content.getJSONArray("serialfilenames");
        Iterator it = obsfilenamesArray.iterator();
        ArrayList<String> SQLlist = new ArrayList<String>();
        JSONArray attachmentidsarray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        while (it.hasNext()) {
            String obsfilename = (String)it.next();
            if (!obsfilemap.containsKey(obsfilename)) continue;
            String filename = obsfilemap.get(obsfilename).get("filename");
            String filetype = obsfilemap.get(obsfilename).get("filetype");
            String parentid = obsfilemap.get(obsfilename).get("parentid");
            filename = filename.replace("'", "");
            try {
                BucketFile bucketFile = new BucketFile(this.siteid);
                if (!bucketFile.doesObjectExist(obsfilename)) continue;
                String mpctaskid = "null";
                String thumbnail_serialfilename = this.createMD5FileName() + ".jgp";
                boolean thumbnail_succsed = false;
                if (this.isVideo(filetype)) {
                    MpcFactory mpcFactoryV2 = new MpcFactory();
                    MediaMetaData data = mpcFactoryV2.getMetaData(this.siteid, obsfilename);
                    if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
                        if (filetype.equalsIgnoreCase("mp4")) {
                            if (data != null) {
                                long bitrate = data.getBitrate();
                                long size = data.getSize();
                                if (bitrate / 1024L > 5000L || size / 0x100000L > 500L) {
                                    mpctaskid = mpcFactoryV2.createTranscodingTask(this.siteid, obsfilename);
                                }
                            }
                        } else if (filetype.equalsIgnoreCase("mov")) {
                            mpctaskid = mpcFactoryV2.createTranscodingTask(this.siteid, obsfilename);
                        }
                    }
                    thumbnail_succsed = mpcFactoryV2.createThumbnailsTask(this.siteid, obsfilename, thumbnail_serialfilename, data.getWidth(), data.getHeight(), 1);
                }
                long attachmentid = this.createTableID("sys_attachment");
                SQLFactory sqlFactory = new SQLFactory(this, "\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                sqlFactory.addParameter("parentid", parentid.equals("") || parentid.equals("0") ? "null" : parentid);
                sqlFactory.addParameter("attachmentid", attachmentid);
                sqlFactory.addParameter("siteid", this.siteid);
                sqlFactory.addParameter("createby", this.username);
                sqlFactory.addParameter("type", "sourcefile");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", obsfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getFileUrl(obsfilename));
                sqlFactory.addParameter("mpctaskid", mpctaskid);
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(obsfilename).getContentLength());
                SQLlist.add(sqlFactory.getSQL());
                if (this.isVideo(filetype) && thumbnail_succsed) {
                    sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", this.siteid);
                    sqlFactory.addParameter("createby", this.username);
                    sqlFactory.addParameter("type", "cover");
                    sqlFactory.addParameter("postfix", "jpg");
                    sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
                    sqlFactory.addParameter("document", thumbnail_serialfilename);
                    sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename));
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                }
                if (this.isImage(filetype)) {
                    sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", this.siteid);
                    sqlFactory.addParameter("createby", this.username);
                    sqlFactory.addParameter("type", "thumbnail");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", "s_" + obsfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getMinImageUrl(obsfilename));
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("s_" + obsfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                    sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", this.siteid);
                    sqlFactory.addParameter("createby", this.username);
                    sqlFactory.addParameter("type", "compressed");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", "c_" + obsfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getCompressImageUrl(obsfilename));
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("c_" + obsfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                }
                obsfilemap.remove(obsfilename);
                bucketFile.close();
                attachmentidsarray.add((Object)attachmentid);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.dbConnect.runSqlUpdate(SQLlist);
        JSONObject object = new JSONObject();
        object.put("attachmentids", (Object)attachmentidsarray);
        resultObject.put("data", (Object)object);
        int filecount = obsfilenamesArray.size();
        if (filecount == SQLlist.size()) {
            resultObject.put("code", (Object)1);
            resultObject.put("msg", (Object)("\u6210\u529f\u4e0a\u4f20" + filecount + "\u4e2a\u6587\u4ef6"));
        } else if (filecount > SQLlist.size() && SQLlist.size() > 0) {
            resultObject.put("code", (Object)1);
            resultObject.put("msg", (Object)("\u6210\u529f\u4e0a\u4f20" + SQLlist.size() + "\u4e2a\u6587\u4ef6,\u5931\u8d25" + (filecount - SQLlist.size()) + "\u4e2a"));
        } else if (SQLlist.size() == 0) {
            resultObject.put("code", (Object)0);
            resultObject.put("msg", (Object)"\u4e0a\u4f20\u5931\u8d25");
        }
        if (!"".equals(this.content.getString("ownertable")) && this.content.getLongValue("ownerid") > 0L && !"".equals(this.content.getString("usetype"))) {
            this.content.put("attachmentids", (Object)attachmentidsarray);
            Attachment attachment = new Attachment(this.content);
            try {
                attachment.createFileLink();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resultObject.put("attinfos", (Object)attachment.queryFileLink());
        }
        return resultObject.toString();
    }

    @API(title="\u83b7\u53d6\u534e\u4e3a\u4e91\u6587\u4ef6\u5939\u4e0b\u8f7d\u8def\u5f84", apiversion=R.ID10020101.v1.class)
    public String createAndGetPackFileUrl() throws YosException {
        String url = "";
        long folderid = this.content.getLong("attachmentid");
        Rows folderrows = this.dbConnect.runSqlQuery("select * from sys_attachment where siteid='" + this.siteid + "' and isfolder=1 and attachmentid='" + folderid + "'");
        if (folderrows.isNotEmpty()) {
            String foldername = folderrows.get(0).getString("document");
            String packfilepath = "cacheFiles/" + Calendar.getInstance().getTimeInMillis() + "/" + foldername + ".zip";
            SQLFactory sqlFactory = new SQLFactory(this, "\u6587\u4ef6\u5939\u5185\u9644\u4ef6\u4fe1\u606f\u67e5\u8be2");
            sqlFactory.addParameter("attachmentid", folderid);
            sqlFactory.addParameter("siteid", this.siteid);
            Rows subrows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
            JSONArray filesArray = new JSONArray();
            HashMap<String, String> filenamemap = new HashMap<String, String>();
            for (Row subrow : subrows) {
                String document = subrow.getString("document");
                String serialnumber = subrow.getString("serialnumber");
                String attachmentid = subrow.getString("attachmentid");
                String parentid = subrow.getString("parentid");
                boolean isfolder = subrow.getBoolean("isfolder");
                if (Long.parseLong(parentid) == folderid || !filenamemap.containsKey(parentid)) {
                    filenamemap.put(attachmentid, document);
                } else if (filenamemap.containsKey(parentid)) {
                    filenamemap.put(attachmentid, (String)filenamemap.get(parentid) + "/" + document);
                }
                if (isfolder) continue;
                JSONObject fileObject = new JSONObject();
                fileObject.put("filepath", (Object)serialnumber);
                fileObject.put("packpath", filenamemap.get(attachmentid));
                filesArray.add((Object)fileObject);
            }
            url = new BucketFile(this.siteid).getPackFileUrl(packfilepath, filesArray);
        }
        return this.getSucReturnObject().addKeyValue("url", url).toString();
    }

    private boolean isImage(String filetype) {
        String[] imagetypes;
        for (String imagetype : imagetypes = new String[]{"JPG", "JPEG", "PNG"}) {
            if (!filetype.equalsIgnoreCase(imagetype)) continue;
            return true;
        }
        return false;
    }

    private boolean isVideo(String filetype) {
        String[] videotypes;
        for (String videotype : videotypes = new String[]{"mp4", "mov", "m4v", "3gp", "mkv", "rm", "rmvb", "wmv", "mpg", "avi", "mpeg"}) {
            if (!filetype.equalsIgnoreCase(videotype)) continue;
            return true;
        }
        return false;
    }

    @API(title="\u4e3a\u6307\u5b9a\u7684\u89c6\u9891\u9644\u4ef6\u751f\u6210\u4e00\u4e2a\u89c6\u9891\u5c01\u9762\u622a\u56fe", apiversion=R.ID10020201.v1.class)
    public String createthumbnail() throws YosException {
        MediaMetaData mediaMetaData;
        long attachmentid = this.content.getLong("attachmentid");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_attachment where siteid='" + this.siteid + "' and attachmentid=" + attachmentid);
        if (rows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230id\u4e3a" + attachmentid + "\u7684\u89c6\u9891\u9644\u4ef6\u4fe1\u606f").toString();
        }
        BucketFile bucketFile = new BucketFile(this.siteid);
        String serialnumber = rows.get(0).getString("serialnumber");
        if (!bucketFile.doesObjectExist(serialnumber)) {
            return this.getErrReturnObject().setErrMsg("OBS\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89c6\u9891\u6587\u4ef6").toString();
        }
        MpcFactory mpcFactoryV2 = new MpcFactory();
        String thumbnail_serialfilename = this.createMD5FileName() + ".jpg";
        boolean thumbnail_succsed = mpcFactoryV2.createThumbnailsTask(this.siteid, serialnumber, thumbnail_serialfilename, (mediaMetaData = mpcFactoryV2.getMetaData(this.siteid, serialnumber)).getWidth(), mediaMetaData.getHeight(), 1);
        if (thumbnail_succsed) {
            SQLFactory sqlFactory = new SQLFactory(this, "\u5b50\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
            sqlFactory.addParameter("parentid", attachmentid);
            sqlFactory.addParameter("attachmentid", this.createTableID("sys_attachment"));
            sqlFactory.addParameter("siteid", this.siteid);
            sqlFactory.addParameter("createby", this.username);
            sqlFactory.addParameter("type", "cover");
            sqlFactory.addParameter("postfix", "jpg");
            sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
            sqlFactory.addParameter("document", thumbnail_serialfilename);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename));
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
            this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
            return this.getSucReturnObject().setData(this.getAttachmentUrl(attachmentid).getRow(0)).toString();
        }
        return this.getErrReturnObject().toString();
    }
}

