/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.department.Department;
import beans.user.User;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.BaseSQL;
import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import utility.tools.Encryption;

public class QuerySQL
extends BaseSQL<QuerySQL>
implements Cloneable {
    private int pageSize = 0;
    private int pageNumber = 0;
    public int pageSize_s = 0;
    private HashMap<String, ArrayList<String>> queryfieldnames = new HashMap();
    private ArrayList<String> orderbylist = new ArrayList();
    private HashMap<String, String> formulafieldMap = new HashMap();
    private ArrayList<String> joinlist = new ArrayList();
    private HashMap<String, BaseClass.JOINTYPE> linkjointypeMap = new HashMap();
    private HashMap<String, String> linktablenameMap = new HashMap();
    private HashMap<String, String> linkconditionMap = new HashMap();
    private ArrayList<String> groupbyList = new ArrayList();
    private boolean isgroupby = false;
    private String rowcountsql = "";
    private static HashMap<String, HashMap<String, FieldMeta>> FieldsMetaMap = new HashMap();
    private static HashMap<Long, RowsMap> tablecolRowsMap = new HashMap();
    private static HashMap<String, RowsMap> tokendatalimitRowsMap = new HashMap();
    private boolean withoutorderby = false;
    private boolean withroledatalimit = true;
    private static int day = 0;
    public static HashMap<String, QuerySQL> QuerySQLMap = new HashMap();

    protected QuerySQL(Controller controller, String tablename) throws YosException {
        super(controller, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
    }

    protected QuerySQL(DBConnect dbConnect, String tablename) throws YosException {
        super(dbConnect, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
    }

    protected QuerySQL(DBConnect dbConnect, String tablename, String ... fieldnames) throws YosException {
        super(dbConnect, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
        this.addQueryFields(fieldnames);
    }

    protected QuerySQL(Controller controller, String tablename, String ... fieldnames) throws YosException {
        super(controller, tablename);
        this.queryfieldnames.put(this.table_alias, new ArrayList());
        this.addQueryFields(fieldnames);
    }

    public BaseSQL setTableAlias(String table_alias) {
        ArrayList<String> list = this.queryfieldnames.get(this.table_alias);
        this.queryfieldnames.remove(this.table_alias);
        this.queryfieldnames.put(table_alias, list);
        this.table_alias = table_alias;
        return this;
    }

    public QuerySQL addQueryFields(String ... fieldnames) {
        for (String fieldname : fieldnames) {
            if (fieldname.contains(".")) {
                String[] c = fieldname.split("\\.");
                String t = c[0];
                String f = c[1];
                if (!this.queryfieldnames.containsKey(t)) {
                    this.queryfieldnames.put(t, new ArrayList());
                }
                if (this.queryfieldnames.get(t).contains(f)) continue;
                this.queryfieldnames.get(t).add(f);
                continue;
            }
            if (this.queryfieldnames.get(this.table_alias).contains(fieldname)) continue;
            this.queryfieldnames.get(this.table_alias).add(fieldname);
        }
        return this;
    }

    public QuerySQL addQueryFields(ArrayList<String> fieldnames) {
        return this.addQueryFields(fieldnames.toArray(new String[0]));
    }

    public QuerySQL addQueryFields(String column_name, String formula) {
        this.formulafieldMap.put(column_name, formula);
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, String tablename, String linkname, String condition) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        if (!this.tableColumnNames.containsKey(tablename)) {
            this.tableColumnNames.put(tablename, this.getTableColumnNames(tablename));
        }
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, QuerySQL querySQL, String linkname, String condition) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, "(" + querySQL.setWithOutOrderBy().getSQL() + ")");
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        if (!this.tableColumnNames.containsKey(this.tablename)) {
            this.tableColumnNames.put(this.tablename, this.getTableColumnNames(this.tablename));
        }
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, String tablename, String linkname, String condition, String ... fieldnames) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        ArrayList<String> linkfieldnames = new ArrayList<String>();
        for (String fieldname : fieldnames) {
            if (!fieldname.contains(".")) {
                fieldname = linkname + "." + fieldname;
            }
            if (linkfieldnames.contains(fieldname)) continue;
            linkfieldnames.add(fieldname);
        }
        this.addQueryFields(linkfieldnames);
        if (!this.tableColumnNames.containsKey(tablename)) {
            this.tableColumnNames.put(tablename, this.getTableColumnNames(tablename));
        }
        return this;
    }

    public QuerySQL addJoinTable(BaseClass.JOINTYPE jointype, QuerySQL querySQL, String linkname, String condition, String ... fieldnames) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, "(" + querySQL.setWithOutOrderBy().getSQL() + ")");
        this.linkconditionMap.put(linkname, this.conditionHander(condition));
        ArrayList<String> linkfieldnames = new ArrayList<String>();
        for (String fieldname : fieldnames) {
            if (!fieldname.contains(".")) {
                fieldname = linkname + "." + fieldname;
            }
            if (linkfieldnames.contains(fieldname)) continue;
            linkfieldnames.add(fieldname);
        }
        this.addQueryFields(linkfieldnames);
        return this;
    }

    private String conditionHander(String condition) {
        condition = condition.replaceAll("(?<![.:])\\s*([-+=><()])\\s*(?![.])", " $1 ");
        return " " + condition + " ";
    }

    public QuerySQL addGroupBy(String ... groupformulas) {
        this.isgroupby = true;
        this.groupbyList.addAll(Arrays.asList(groupformulas));
        return this;
    }

    public String getSQL() throws YosException {
        this.rowcountsql = "";
        String fields_str = "";
        StringBuilder jointable_str = new StringBuilder();
        StringBuilder where_str = new StringBuilder(" where (1=1) ");
        if (!this.isgroupby && this.queryfieldnames.containsKey(this.table_alias) && this.queryfieldnames.get(this.table_alias).isEmpty()) {
            this.addQueryFields((ArrayList)this.tableColumnNames.get(this.tablename));
        }
        for (String tablekey : this.queryfieldnames.keySet()) {
            for (String fieldname : this.queryfieldnames.get(tablekey)) {
                fields_str = fields_str.equals("") ? tablekey + "." + fieldname : fields_str + "," + tablekey + "." + fieldname;
            }
        }
        for (String linkname : this.joinlist) {
            String linktablename = this.linktablenameMap.get(linkname);
            String linkcondition = this.parameterDo(this.linkconditionMap.getOrDefault(linkname, ""));
            BaseClass.JOINTYPE jointype = this.linkjointypeMap.get(linkname);
            for (String tablefield : (ArrayList)this.tableColumnNames.get(this.tablename)) {
                linkcondition = linkcondition.replaceAll(":" + tablefield, this.table_alias + "." + tablefield);
            }
            for (String linktablefield : (ArrayList)this.tableColumnNames.get(linktablename)) {
                if (!linkcondition.contains(" " + linktablefield + " ")) continue;
                linkcondition = linkcondition.replaceAll(" " + linktablefield + " ", " " + linkname + "." + linktablefield + " ");
            }
            jointable_str.append(" ").append(jointype.toString()).append(" join ").append(linktablename).append(" as ").append(linkname).append(" on ").append(linkcondition);
        }
        for (String column_name : this.formulafieldMap.keySet()) {
            fields_str = fields_str.equals("") ? "(" + this.formulafieldMap.get(column_name) + ") as " + column_name : fields_str + ",(" + this.formulafieldMap.get(column_name) + ") as " + column_name;
        }
        fields_str = fields_str.equals("") ? "*" : fields_str;
        this.clientFieldFilterAndSort(fields_str, jointable_str.toString());
        for (Iterator<String> where : this.wherelist) {
            where_str.append(" and ").append(this.parameterDo((String)((Object)where)));
        }
        StringBuilder groupby_str = new StringBuilder();
        if (this.isgroupby) {
            if (this.groupbyList.isEmpty()) {
                for (String tkey : this.queryfieldnames.keySet()) {
                    for (String f : this.queryfieldnames.get(tkey)) {
                        this.groupbyList.add(tkey + "." + f);
                    }
                }
            }
            for (String groupby : this.groupbyList) {
                (groupby_str.toString().equals("") ? groupby_str.append("group by ") : groupby_str.append(", ")).append(groupby);
            }
        }
        String sql_str = "";
        if (this.withroledatalimit && this.controller != null && !this.controller.getAccesstoken().equals("")) {
            sql_str = "select " + fields_str + " from " + this.addRoleDataLimit() + jointable_str + where_str + groupby_str;
            this.rowcountsql = "select count(0) as rowscount, CEILING(count(0)/(" + this.pageSize + "*1.0)) pagecount from " + this.addRoleDataLimit() + jointable_str + where_str + groupby_str;
        } else {
            sql_str = "select " + fields_str + " from " + this.tablename + " as " + this.table_alias + jointable_str + where_str + groupby_str;
            this.rowcountsql = "select count(0) as rowscount, CEILING(count(0)/(" + this.pageSize + "*1.0)) pagecount from " + this.tablename + " as " + this.table_alias + jointable_str + where_str + groupby_str;
        }
        return this.addPageSQLStr(sql_str);
    }

    private void clientFieldFilterAndSort(String fields_str, String jointable_str) throws YosException {
        long tableid;
        if (this.pageNumber > 0 && this.pageSize > 0 && this.controller != null && (tableid = this.controller.content.getLongValue("tableid")) > 0L) {
            String FieldsMetaMapKey = this.controller.requestAPI.getId() + "-" + this.controller.requestAPI.getVersion();
            if (!FieldsMetaMap.containsKey(FieldsMetaMapKey)) {
                FieldsMetaMap.put(FieldsMetaMapKey, this.controller.dbConnect.runSqlQuery("select " + fields_str + " from " + this.tablename + " as " + this.table_alias + jointable_str + " where 1=2").getFieldMetaMap());
            }
            if (!tablecolRowsMap.containsKey(tableid)) {
                tablecolRowsMap.put(tableid, this.controller.dbConnect.runSqlQuery("select columnname,filter,sortable from sys_systemapp_tablecols where tableid=" + tableid + " and (sortable=1 or filter in (1,2)) ").toRowsMap("columnname"));
            }
            if (this.controller.content.containsKey("where") && this.controller.content.getJSONObject("where").containsKey("tablefilter")) {
                JSONObject tablefilter = this.controller.content.getJSONObject("where").getJSONObject("tablefilter");
                for (String columnname : tablefilter.keySet()) {
                    String filtervalue = tablefilter.getStringValue(columnname);
                    if (filtervalue.equals("") || !FieldsMetaMap.get(FieldsMetaMapKey).containsKey(columnname) || !tablecolRowsMap.get(tableid).containsKey(columnname)) continue;
                    String table_alias = FieldsMetaMap.get(FieldsMetaMapKey).get(columnname).getTable_alias();
                    Class fieldclazztype = FieldsMetaMap.get(FieldsMetaMapKey).get(columnname).getFieldtype();
                    int filter = tablecolRowsMap.get(tableid).get(columnname).get(0).getInteger("filter");
                    if (fieldclazztype == Integer.class || fieldclazztype == Long.class || fieldclazztype == Float.class || fieldclazztype == Double.class || fieldclazztype == Date.class) {
                        if (filter == 1) {
                            this.setWhere(table_alias + "." + columnname + "=" + filtervalue.replaceFirst("=", ""));
                            continue;
                        }
                        if (filter != 2) continue;
                        if (filtervalue.startsWith(">=")) {
                            this.setWhere(table_alias + "." + columnname + ">=" + filtervalue.replaceFirst(">=", ""));
                            continue;
                        }
                        if (filtervalue.startsWith("<=")) {
                            this.setWhere(table_alias + "." + columnname + "<=" + filtervalue.replaceFirst("<=", ""));
                            continue;
                        }
                        if (filtervalue.startsWith(">")) {
                            this.setWhere(table_alias + "." + columnname + ">" + filtervalue.replaceFirst(">", ""));
                            continue;
                        }
                        if (filtervalue.startsWith("<")) {
                            this.setWhere(table_alias + "." + columnname + "<" + filtervalue.replaceFirst("<", ""));
                            continue;
                        }
                        this.setWhere(table_alias + "." + columnname + "=" + filtervalue.replaceFirst("=", ""));
                        continue;
                    }
                    if (filter == 1) {
                        this.setWhere(table_alias + "." + columnname + "='" + filtervalue.replaceFirst("=", "'"));
                        continue;
                    }
                    if (filter != 2) continue;
                    this.setWhere(table_alias + "." + columnname + " like '%" + filtervalue + "%'");
                }
            }
            if (this.controller.content.containsKey("simplesort")) {
                JSONObject simplesortObject = this.controller.content.getJSONObject("simplesort");
                for (String fieldname : simplesortObject.keySet()) {
                    if (!FieldsMetaMap.get(FieldsMetaMapKey).containsKey(fieldname) || !tablecolRowsMap.get(tableid).containsKey(fieldname) || !tablecolRowsMap.get(tableid).get(fieldname).get(0).getBoolean("sortable").booleanValue()) continue;
                    this.orderbylist.clear();
                    String table_alias = FieldsMetaMap.get(FieldsMetaMapKey).get(fieldname).getTable_alias();
                    this.orderbylist.add(table_alias + "." + fieldname + (simplesortObject.getBooleanValue(fieldname) ? " asc" : " desc"));
                }
            }
        }
    }

    public static void cleanDataLimitRowsMapPool(String accesstoken) throws YosException {
        tokendatalimitRowsMap.remove(accesstoken);
    }

    private String addRoleDataLimit() throws YosException {
        String where_str = "1=2";
        if (!tokendatalimitRowsMap.containsKey(this.controller.getAccesstoken())) {
            RowsMap rowsMap = this.controller.dbConnect.runSqlQuery("select distinct t2.sqlstr,t2.table_name from sys_userrole t1 inner join sys_role_datalimit t2 on t1.roleid=t2.roleid where t1.siteid='" + this.controller.siteid + "' and t1.userid='" + this.controller.userid + "'").toRowsMap("table_name");
            tokendatalimitRowsMap.put(this.controller.getAccesstoken(), rowsMap);
        }
        Rows limitSqlRows = tokendatalimitRowsMap.get(this.controller.getAccesstoken()).get(this.tablename);
        for (Row limitSqlRow : limitSqlRows) {
            ArrayList<Long> sublist;
            String sqlstr = limitSqlRow.getString("sqlstr").trim();
            if (sqlstr.equals("")) continue;
            sqlstr = sqlstr.replace(":hrid", String.valueOf(this.controller.hrid));
            sqlstr = sqlstr.replace(":userid", String.valueOf(this.controller.userid));
            sqlstr = sqlstr.replace(":sys_enterpriseid", String.valueOf(this.controller.sys_enterpriseid));
            if ((sqlstr = sqlstr.replace(":departmentid", String.valueOf(this.controller.departmentid))).contains(":subhrids")) {
                sublist = User.getSubHrIds(this.controller);
                sublist.add(this.controller.hrid);
                sqlstr = sqlstr.replace(":subhrids", sublist.toString().replace("[", "(").replace("]", ")"));
            }
            if (sqlstr.contains(":subuserids")) {
                sublist = User.getSubUserIds(this.controller);
                sublist.add(this.controller.userid);
                sqlstr = sqlstr.replace(":subuserids", sublist.toString().replace("[", "(").replace("]", ")"));
            }
            if (sqlstr.contains(":subsys_enterpriseids")) {
                ArrayList<Long> subhridlist = User.getSubHrIds(this.controller);
                subhridlist.add(this.controller.hrid);
                SQLFactory sqlFactory = new SQLFactory("sql:select distinct sys_enterpriseid from sys_enterprise_tradefield where siteid='" + this.controller.siteid + "' and hrid in $hrids$");
                sqlFactory.addParameter_in("hrids", subhridlist);
                ArrayList sublist2 = this.controller.dbConnect.runSqlQuery(sqlFactory.getSQL()).toArrayList("sys_enterpriseid", new ArrayList());
                sqlstr = sublist2.isEmpty() ? sqlstr.replace(":subsys_enterpriseids", "(null)") : sqlstr.replace(":subsys_enterpriseids", sublist2.toString().replace("[", "(").replace("]", ")"));
            }
            if (sqlstr.contains(":subdepartmentids")) {
                sublist = Department.getSubDepartmentIds(this.controller, this.controller.departmentid);
                sublist.add(this.controller.departmentid);
                sqlstr = sqlstr.replace(":subdepartmentids", sublist.toString().replace("[", "(").replace("]", ")"));
            }
            where_str = where_str + " or (" + sqlstr + ")";
        }
        if (where_str.equals("1=2")) {
            if (this.tablename.equals(this.table_alias)) {
                return this.tablename;
            }
            return this.tablename + " as " + this.table_alias;
        }
        return "(select * from " + this.tablename + " where " + where_str + ") as " + this.table_alias;
    }

    private QuerySQL setWithOutOrderBy() {
        this.withoutorderby = true;
        return this;
    }

    private String addPageSQLStr(String sql_str) throws YosException {
        if (!this.withoutorderby) {
            String orderby_str = "";
            for (String orderby : this.orderbylist) {
                orderby_str = orderby_str.equals("") ? orderby : "," + orderby;
            }
            String string = orderby_str = orderby_str.equals("") ? this.table_alias + "." + this.uniquecolumnname : orderby_str;
            if (this.pageNumber > 0 && this.pageSize > 0) {
                if (this.dbConnect.getDBProduct().equals("MySQL")) {
                    Row countrow = this.dbConnect.runSqlQuery(0, this.rowcountsql);
                    long rowscount = countrow.getLong("rowscount");
                    long pagecount = countrow.getBigDecimal("pagecount").longValue();
                    sql_str = sql_str.replaceFirst("(?i)select", "select " + rowscount + " as total," + pagecount + " as pageTotal," + this.pageNumber + " as pageNumber," + this.pageSize + " as pageSize,");
                    sql_str = sql_str + " order by " + orderby_str + " limit " + (this.pageNumber - 1) * this.pageSize + "," + this.pageSize;
                } else {
                    sql_str = sql_str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderby_str + " )rowindex,");
                    sql_str = sql_str + " )select * from p2dbconnectstring t1 inner join (select count(0)total,CEILING(count(0)/(" + this.pageSize + "*1.0)) pageTotal from p2dbconnectstring) t2 on 1=1 where rowindex>(" + this.pageNumber + "-1)*" + this.pageSize + " and rowindex<=" + this.pageNumber + "*" + this.pageSize;
                }
            } else if (!this.isgroupby) {
                sql_str = sql_str + " order by " + orderby_str;
            }
        }
        return sql_str;
    }

    public QuerySQL setRoleDataLimit(boolean withroledatalimit) {
        this.withroledatalimit = withroledatalimit;
        return this;
    }

    public QuerySQL setOrderBy(String ... orderbys) {
        this.orderbylist.addAll(Arrays.asList(orderbys));
        return this;
    }

    public QuerySQL setPage(int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.pageSize_s = pageSize;
        this.pageNumber = pageNumber;
        return this;
    }

    public Rows query() throws YosException {
        Rows rows = this.dbConnect.runSqlQuery(this.getSQL());
        if (this.controller != null && this.pageSize > 0 && this.pageNumber > 0) {
            int today = Calendar.getInstance().get(5);
            if (day != today) {
                QuerySQLMap.clear();
                day = today;
            }
            String listqueryid = Encryption.Encode_MD5(this.controller.getAccesstoken() + "_" + this.controller.requestAPI.getApi().apiversion().getName());
            QuerySQLMap.put(listqueryid, this);
            rows.listqueryid = listqueryid;
        }
        return rows;
    }

    public Rows query(int rowindex) throws YosException {
        Rows rows = new Rows();
        if (this.controller != null) {
            this.pageSize = 1;
            this.pageNumber = rowindex;
            rows = this.query();
            if (rows.isNotEmpty()) {
                rows.get(0).put("rowindex", rowindex);
            }
        }
        return rows;
    }

    public QuerySQL clone() throws CloneNotSupportedException {
        return (QuerySQL)super.clone();
    }
}

