/*
 * Decompiled with CFR 0.152.
 */
package common;

import beans.yl.MessageMonitoringStation;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.api.YOSAPI;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.data.db.initialization.DBInitialization;
import common.parameter.properties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class InitServlet
extends HttpServlet
implements ServletContextListener {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(InitServlet.class);

    public void init(ServletConfig config) {
        try {
            MessageMonitoringStation.send("\u6b63\u5728\u52a0\u8f7d...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CookieHandler.setDefault(new CookieManager());
        PropertyConfigurator.configure((Properties)properties.getLog4jProperties());
        this.SQLiteInit();
        DBInitialization.SchemaInit();
        YOSAPI.initialize();
        this.ApiMonitorInit();
        this.ApiClean();
        try {
            super.init();
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            Class<?> clz = Class.forName("common.InitService");
            Constructor<?> cla = clz.getDeclaredConstructor(new Class[0]);
            Object obj = cla.newInstance(new Object[0]);
            service.scheduleWithFixedDelay((Runnable)obj, 5L, 600L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageMonitoringStation.send("\u542f\u52a8\u5b8c\u6210!");
        MessageMonitoringStation.heartBeat();
    }

    private void SQLiteInit() {
        try {
            DBConnect dbConnect = new DBConnect();
            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_cacheobjectcols");
            insertSQL.setValue("sys_cacheobjectcolsid", insertSQL.createTableID("sys_cacheobjectcols"));
            insertSQL.setValue("table_name", "apirequestsqllog");
            insertSQL.setValue("column_type", "int");
            insertSQL.setValue("column_name", "numofaffectedrows");
            insertSQL.setValue("column_comment", "\u5f71\u54cd\u884c\u6570");
            insertSQL.setWhere("not exists(select * from sys_cacheobjectcols where table_name='apirequestsqllog' and column_name='numofaffectedrows' )");
            insertSQL.insert();
            Rows sys_cacheobjectRows = dbConnect.runSqlQuery("select table_name from sys_cacheobject");
            RowsMap sys_cacheobjectcolsRowsMap = dbConnect.runSqlQuery("select table_name,column_name,column_type from sys_cacheobjectcols").toRowsMap("table_name");
            for (Row sys_cacheobjectRow : sys_cacheobjectRows) {
                String table_name = sys_cacheobjectRow.getString("table_name");
                Rows sys_cacheobjectcolsRows = sys_cacheobjectcolsRowsMap.get(table_name);
                if (sys_cacheobjectcolsRows.isEmpty()) continue;
                this.logger.info((Object)("\u521b\u5efa\u7f13\u5b58\u6570\u636e\u8868\uff1a" + table_name));
                SQLiteTable sqLiteTable = SQLiteTable.getTable(table_name);
                if (!sqLiteTable.dosNotExist()) continue;
                block16: for (Row sys_cacheobjectcolsRow : sys_cacheobjectcolsRows) {
                    String column_type;
                    String column_name = sys_cacheobjectcolsRow.getString("column_name").toLowerCase();
                    switch (column_type = sys_cacheobjectcolsRow.getString("column_type").toLowerCase()) {
                        case "datetime": {
                            sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.DATETIME);
                            continue block16;
                        }
                        case "date": {
                            sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.DATE);
                            continue block16;
                        }
                        case "bigint": {
                            sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.BIGINT);
                            continue block16;
                        }
                        case "int": {
                            sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.INT);
                            continue block16;
                        }
                    }
                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.VARCHAR);
                }
                sqLiteTable.create();
            }
        }
        catch (YosException e) {
            e.printStackTrace();
        }
    }

    private void ApiMonitorInit() {
        ArrayList<String> SQLlist = new ArrayList<String>();
        Reflections reflections = new Reflections("restcontroller", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Controller.class);
        for (Class clazz : subTypes) {
            Method[] methods;
            String classname = clazz.getName().replace("restcontroller.", "");
            String classtitle = "";
            String classnotes = "";
            boolean isapiclass = false;
            if (clazz.isAnnotationPresent(API.class)) {
                API classapi = clazz.getAnnotation(API.class);
                classtitle = classapi.title();
                classnotes = classapi.notes();
            }
            for (Method method : methods = clazz.getDeclaredMethods()) {
                int deprecated;
                if (!method.isAnnotationPresent(API.class)) continue;
                boolean iscacheing = method.isAnnotationPresent(CACHEING.class);
                int cacheinglife = iscacheing ? method.getAnnotation(CACHEING.class).life() : 0;
                boolean iscacheingclean = method.isAnnotationPresent(CACHEING_CLEAN.class);
                JSONArray cacheingcleanArray = new JSONArray();
                if (iscacheingclean) {
                    String[] systemapps;
                    String[] tablenames;
                    YOSAPI yosapi;
                    Class[] apiClasses;
                    Class[] apiversionclasses;
                    cm[] cms;
                    CACHEING_CLEAN cacheing_clean = method.getAnnotation(CACHEING_CLEAN.class);
                    for (cm cm2 : cms = cacheing_clean.cms()) {
                        String[] mds;
                        String[] stringArray = mds = cm2.method();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String md = stringArray[i];
                            try {
                                Method m = cm2.clazz().getMethod(md, new Class[0]);
                                if (!m.isAnnotationPresent(API.class)) continue;
                                API a = m.getAnnotation(API.class);
                                JSONObject cacheingcleanObject = new JSONObject(true);
                                cacheingcleanObject.put("classname", (Object)cm2.clazz().getName().replace("restcontroller.", ""));
                                cacheingcleanObject.put("method", (Object)m.getName());
                                cacheingcleanObject.put("title", (Object)a.title());
                                cacheingcleanObject.put("notes", (Object)a.notes());
                                cacheingcleanArray.add((Object)cacheingcleanObject);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    for (Class apiversionclass : apiversionclasses = cacheing_clean.apiversions()) {
                        try {
                            YOSAPI yosapi2 = YOSAPI.getApi(apiversionclass);
                            if (yosapi2 == null) continue;
                            Method m = yosapi2.getMethod();
                            API a = yosapi2.getMethod().getAnnotation(API.class);
                            JSONObject cacheingcleanObject = new JSONObject(true);
                            cacheingcleanObject.put("classname", (Object)yosapi2.getClazz().getName().replace("restcontroller.", ""));
                            cacheingcleanObject.put("method", (Object)m.getName());
                            cacheingcleanObject.put("title", (Object)a.title());
                            cacheingcleanObject.put("notes", (Object)a.notes());
                            cacheingcleanObject.put("id", (Object)yosapi2.getId());
                            cacheingcleanObject.put("version", (Object)yosapi2.getVersion());
                            cacheingcleanArray.add((Object)cacheingcleanObject);
                        }
                        catch (YosException e) {
                            e.printStackTrace();
                        }
                    }
                    for (Class apiClass : apiClasses = cacheing_clean.apiClass()) {
                        try {
                            Method[] methods1;
                            for (Method method1 : methods1 = apiClass.getMethods()) {
                                if (!method1.isAnnotationPresent(API.class) || !method1.isAnnotationPresent(CACHEING.class) || (yosapi = YOSAPI.getApi(method1.getAnnotation(API.class).apiversion())) == null) continue;
                                API a = yosapi.getMethod().getAnnotation(API.class);
                                JSONObject cacheingcleanObject = new JSONObject(true);
                                cacheingcleanObject.put("classname", (Object)yosapi.getClazz().getName().replace("restcontroller.", ""));
                                cacheingcleanObject.put("method", (Object)method1.getName());
                                cacheingcleanObject.put("title", (Object)a.title());
                                cacheingcleanObject.put("notes", (Object)a.notes());
                                cacheingcleanObject.put("id", (Object)yosapi.getId());
                                cacheingcleanObject.put("version", (Object)yosapi.getVersion());
                                cacheingcleanArray.add((Object)cacheingcleanObject);
                            }
                        }
                        catch (YosException e) {
                            e.printStackTrace();
                        }
                    }
                    for (String tablename : tablenames = cacheing_clean.tablename()) {
                        try {
                            DBConnect dbConnect = new DBConnect();
                            Rows rows = dbConnect.runSqlQuery("select distinct t2.apiid,t2.apiversion from sys_objectapps t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.table_name='" + tablename + "'");
                            for (Row row : rows) {
                                yosapi = YOSAPI.getApi(row.getLong("apiid"), row.getInteger("apiversion"));
                                if (yosapi == null) continue;
                                Method m = yosapi.getMethod();
                                API a = yosapi.getMethod().getAnnotation(API.class);
                                JSONObject cacheingcleanObject = new JSONObject(true);
                                cacheingcleanObject.put("classname", (Object)yosapi.getClazz().getName().replace("restcontroller.", ""));
                                cacheingcleanObject.put("method", (Object)m.getName());
                                cacheingcleanObject.put("title", (Object)a.title());
                                cacheingcleanObject.put("notes", (Object)a.notes());
                                cacheingcleanObject.put("id", (Object)yosapi.getId());
                                cacheingcleanObject.put("version", (Object)yosapi.getVersion());
                                cacheingcleanArray.add((Object)cacheingcleanObject);
                            }
                        }
                        catch (YosException e) {
                            e.printStackTrace();
                        }
                    }
                    for (String systemapp : systemapps = cacheing_clean.systemapp()) {
                        try {
                            DBConnect dbConnect = new DBConnect();
                            Rows rows = dbConnect.runSqlQuery("select distinct t2.apiid,t2.apiversion from sys_systemapp t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.systemapp='" + systemapp + "'");
                            for (Row row : rows) {
                                YOSAPI yosapi3 = YOSAPI.getApi(row.getLong("apiid"), row.getInteger("apiversion"));
                                if (yosapi3 == null) continue;
                                Method m = yosapi3.getMethod();
                                API a = yosapi3.getMethod().getAnnotation(API.class);
                                JSONObject cacheingcleanObject = new JSONObject(true);
                                cacheingcleanObject.put("classname", (Object)yosapi3.getClazz().getName().replace("restcontroller.", ""));
                                cacheingcleanObject.put("method", (Object)m.getName());
                                cacheingcleanObject.put("title", (Object)a.title());
                                cacheingcleanObject.put("notes", (Object)a.notes());
                                cacheingcleanObject.put("id", (Object)yosapi3.getId());
                                cacheingcleanObject.put("version", (Object)yosapi3.getVersion());
                                cacheingcleanArray.add((Object)cacheingcleanObject);
                            }
                        }
                        catch (YosException e) {
                            e.printStackTrace();
                        }
                    }
                }
                API methdapi = method.getAnnotation(API.class);
                Class apiversionClass = methdapi.apiversion();
                String apiversion = apiversionClass.getName().toLowerCase();
                int n = deprecated = methdapi.deprecated() ? 1 : 0;
                if (apiversion.startsWith("restcontroller.r$id") && apiversion.contains("$v")) {
                    int version = Integer.parseInt(apiversionClass.getSimpleName().replace("v", ""));
                    long apiid = Long.parseLong(apiversion.replace("restcontroller.r$id", "").replace("$v" + version, ""));
                    SQLlist.add("insert into apimethod(classname,method,title,notes,cacheinglife,iscacheing,iscacheingclean,cleandatas,intervaltime,accesstoken,apiid,apiversion,deprecated) values ('" + classname + "','" + method.getName() + "','" + methdapi.title() + "','" + methdapi.notes() + "','" + cacheinglife + "','" + (iscacheing ? 1 : 0) + "','" + (iscacheingclean ? 1 : 0) + "','" + cacheingcleanArray.toJSONString() + "','" + methdapi.intervaltime() + "','" + (methdapi.accesstoken() ? "1" : "0") + "','" + apiid + "','" + version + "'," + deprecated + ");");
                } else {
                    SQLlist.add("insert into apimethod(classname,method,title,notes,cacheinglife,iscacheing,iscacheingclean,cleandatas,intervaltime,accesstoken,apiid,apiversion,deprecated) values ('" + classname + "','" + method.getName() + "','" + methdapi.title() + "','" + methdapi.notes() + "','" + cacheinglife + "','" + (iscacheing ? 1 : 0) + "','" + (iscacheingclean ? 1 : 0) + "','" + cacheingcleanArray.toJSONString() + "','" + methdapi.intervaltime() + "','" + (methdapi.accesstoken() ? "1" : "0") + "','',''," + deprecated + ");");
                }
                isapiclass = true;
            }
            if (!isapiclass) continue;
            SQLlist.add("insert into apiclass(classname,title,notes) values ('" + classname + "','" + classtitle + "','" + classnotes + "' );");
        }
        SQLiteMemory.runSqlUpdate(SQLlist);
    }

    public void ApiClean() {
        try {
            String apiid;
            Rows apimethodRows = SQLiteMemory.runSqlQuery("select classname,method,apiid,apiversion from apimethod");
            ArrayList<String> methodpathList = new ArrayList<String>();
            for (Row apimethodRow : apimethodRows) {
                methodpathList.add("restcontroller." + apimethodRow.getString("classname") + "." + apimethodRow.getString("method"));
            }
            ArrayList<String> apiidList = apimethodRows.toArrayList("apiid");
            ArrayList<String> sqlist = new ArrayList<String>();
            DBConnect dbConnect = new DBConnect();
            Rows sys_listsortschemeRows = dbConnect.runSqlQuery("select * from sys_listsortscheme");
            for (Object sys_listsortschemeRow : sys_listsortschemeRows) {
                long sys_listsortschemeid = ((Row)sys_listsortschemeRow).getLong("sys_listsortschemeid");
                String methodpath = ((Row)sys_listsortschemeRow).getString("methodpath");
                apiid = ((Row)sys_listsortschemeRow).getString("apiid");
                String apiversion = ((Row)sys_listsortschemeRow).getString("apiversion");
                if (methodpathList.contains(methodpath) || apiidList.contains(apiid)) continue;
                sqlist.add("delete from sys_listsortscheme where sys_listsortschemeid=" + sys_listsortschemeid);
            }
            Rows sys_apiappsRows = dbConnect.runSqlQuery("select * from sys_apiapps");
            for (Row sys_apiappsRow : sys_apiappsRows) {
                long sys_apiappsid = sys_apiappsRow.getLong("sys_apiappsid");
                apiid = sys_apiappsRow.getString("apiid");
                if (apiidList.contains(apiid)) continue;
                sqlist.add("delete from sys_apiapps where sys_apiappsid=" + sys_apiappsid);
            }
            Rows sys_apidocRows = dbConnect.runSqlQuery("select * from sys_apidoc");
            for (Row sys_apidocRow : sys_apidocRows) {
                long sys_apidocid = sys_apidocRow.getLong("sys_apidocid");
                String apiid2 = sys_apidocRow.getString("apiid");
                if (apiidList.contains(apiid2)) continue;
                sqlist.add("delete from sys_apidoc where sys_apidocid=" + sys_apidocid);
            }
            sqlist.add("delete from sys_listsortschememx where not exists (select *from sys_listsortscheme where sys_listsortscheme.sys_listsortschemeid=sys_listsortschememx.sys_listsortschemeid)");
            dbConnect.runSqlUpdate(sqlist);
        }
        catch (YosException e) {
            e.printStackTrace();
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            MessageMonitoringStation.send("\u6b63\u5728\u542f\u52a8...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            MessageMonitoringStation.send("\u6b63\u5728\u5173\u95ed\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

