package service;

import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import utility.tools.MessageMonitoringStation;
import common.ServiceController;
import common.YosException;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

/**
 * 数据异常监控
 */
public class DataValidate extends ServiceController {
    @Override
    public void serviceRun() throws YosException {
        try {
            QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "sys_datawarn", "title", "sqlstr", "datakey");
            querySQL.setWhere("isused", 1);
            querySQL.setWhere("type", "error");
            querySQL.setOrderBy("sequence");
            Rows rows = querySQL.query();
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                String title = row.getString("title");
                try {
                    Rows errdatas;
                    if (datakey.equals("") || datakey.equalsIgnoreCase("default")) {
                        errdatas = dbConnect.runSqlQuery(row.getString("sqlstr"));
                    } else if (datakey.equalsIgnoreCase("sqliteCache")) {
                        errdatas = SQLiteMemory.runSqlQuery(row.getString("sqlstr"));
                    } else {
                        errdatas = new DBConnect(datakey).runSqlQuery(row.getString("sqlstr"));
                    }
                    int errcount = errdatas.size();
                    if (errcount > 0) {
                        MessageMonitoringStation.send("[" + title + "],异常数 " + errcount);
                    }
                } catch (Exception e) {
                    MessageMonitoringStation.send("[" + title + "]查询出错，请检查");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
