package restcontroller.sysmanage.develop.optiontype;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

import java.util.Iterator;

import common.YosException;
import restcontroller.R;

@API(title = "管理端-开发-选项分类")
public class optiontype extends Controller {

    public optiontype(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统选项分类选择查询", apiversion = R.ID10014701.v1.class)
    public String optiontypeselect() throws YosException {
        String typename = content.getString("typename");
        Rows optiontypeRows = dbConnect.runSqlQuery("select optiontypeid,issql,issubvaluemag from sys_optiontype where typename='" + typename + "'");
        if (optiontypeRows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到指定的选项分类").toString();
        }
        boolean issql = optiontypeRows.get(0).getBoolean("issql");
        long optiontypeid = optiontypeRows.get(0).getLong("optiontypeid");
        if (issql) {
            Rows optiontypemxrows = dbConnect.runSqlQuery("select value,siteid from sys_optiontypemx where isused=1 and (ifnull(siteid,'')='' or siteid='" + siteid + "') and optiontypeid='" + optiontypeid + "' limit 0,1");
            if (optiontypemxrows.isEmpty()) {
                return getErrReturnObject().setErrMsg("没有有效的选项分类查询").toString();
            } else {
                String sql = optiontypemxrows.get(0).getString("value");
                String psiteid = optiontypemxrows.get(0).getString("siteid");
                if (content.containsKey("parameter")) {
                    JSONObject parameterObject = content.getJSONObject("parameter");
                    Iterator<String> it = parameterObject.keySet().iterator();
                    while (it.hasNext()) {
                        String parameter = it.next();
                        String value = String.valueOf(parameterObject.get(parameter));
                        String sqlkey = "$" + parameter + "$";
                        if (value == null || "null".equalsIgnoreCase(value)) {
                            sql = sql.replace(sqlkey, "NULL");
                        } else {
                            sql = sql.replace(sqlkey, "'" + value + "'");
                        }
                    }
                    if (!psiteid.equals("") && !psiteid.equalsIgnoreCase("null")) {
                        /**
                         * 如果参数没有传递站点，且当前分类已经指定站点，则传入指定站点
                         */
                        sql = sql.replaceAll("(?i)\\u0024siteid\\u0024", "'" + psiteid + "'");
                    }
                }
                /**
                 * 如果以上条件还未消除站点信息，则将当前账号站点传入
                 */
                sql = sql.replaceAll("(?i)\\u0024siteid\\u0024", "'" + siteid + "'");
                sql = sql.replaceAll("(?i):sys_enterpriseid", "'" + sys_enterpriseid + "'");
                sql = sql.replaceAll("(?i):userid", "'" + userid + "'");
                sql = sql.replaceAll("(?i):hrid", "'" + hrid + "'");
                sql = sql.replaceAll("(?i):departmentid", "'" + departmentid + "'");
                sql = sql.replaceAll("(?i):siteid", "'" + siteid + "'");

                sql = sql.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                sql = sql + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;

                Rows rows = dbConnect.runSqlQuery(sql);
                return getSucReturnObject().setData(rows).toString();
            }
        } else {
            if (optiontypeRows.get(0).getBoolean("issubvaluemag")) {
                Rows rows = dbConnect.runSqlQuery("select value,subvalues,remarks from sys_optiontypemx where isused=1 and (ifnull(siteid,'')='' or siteid='" + siteid + "') and optiontypeid='" + optiontypeid + "'");
                for (Row row : rows) {
                    try {
                        JSONArray subvaluesArray = row.getJSONArray("subvalues");
                        row.put("subvalues", subvaluesArray);
                    } catch (Exception e) {
                        row.put("subvalues", new JSONArray());
                    }
                }
                return getSucReturnObject().setData(rows).toString();
            } else {
                Rows rows = dbConnect.runSqlQuery("select value,remarks from sys_optiontypemx where isused=1 and (ifnull(siteid,'')='' or siteid='" + siteid + "') and optiontypeid='" + optiontypeid + "'");
                return getSucReturnObject().setData(rows).toString();
            }
        }
    }
}
