package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class w_iotpayorder implements YosObject {
    @Override
    public String table_comment() {
        return "物联卡充值";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("w_iotpayorderid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("orderno", "订单号", 50));
        list.add(new VarcharCol("telecomoperator", "运营商", 50));
        list.add(new VarcharCol("chargemoney", "充值金额", 50, ""));
        list.add(new IntCol("status", "状态0 失败 1 成功 2 待处理", 2));
        list.add(new VarcharCol("resultcode", "订单处理结果", 50, ""));
        list.add(new LongTextCol("resultdesc", "订单处理描述", "订单处理描述"));
        list.add(new VarcharCol("createby", "付费人", "付费人", 50, false, false, false, "", 0));
        list.add(new DateTimeCol("createdate", "创建时间", "创建时间", false, false, "", 0));
        list.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 0));
        list.add(new BigIntCol("w_iotcard_paramid", "w_iotcard_paramid"));

        return list;
    }
}
