package common.parameter;

import common.data.Row;
import common.data.Rows;
import common.websocket.WebSocket;

import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 参数及全局数据表
 *
 * @author SHENJW
 */
public class parameter {
    /**
     * token:usersiteid对应表
     */
    public static HashMap<String, Long> tokenlist = new HashMap<String, Long>(16);
    /**
     * token:sessionid对应表
     */
    public static HashMap<String, String> tokenSessionidlist = new HashMap<String, String>(16);
    /**
     * token:systemclient对应表
     */
    public static HashMap<String, String> tokensystemclientlist = new HashMap<String, String>(16);
    /**
     * usersiteid:账号信息 对应表
     */
    public static HashMap<Long, Row> usersiteIdList = new HashMap<Long, Row>(16);
    /**
     * 登录 手机号:验证码 对应表
     */
    public static HashMap<String, String> phonenumber_password = new HashMap<String, String>(16);

    /**
     * 登陆 验证码:请求端 对应表
     */
    public static HashMap<String, String> password_systemclient = new HashMap<String, String>(16);

    /**
     * 登录 验证码:有效期 对应表
     */
    public static HashMap<String, Date> phonenumber_date = new HashMap<String, Date>(16);
    /**
     * 修改手机号-手机号、验证码
     */
    public static HashMap<String, String> changephonenumber_passwordmap = new HashMap<String, String>(16);
    /**
     * 修改手机号-验证码、有效期
     */
    public static HashMap<String, Date> changephonenumber_date = new HashMap<String, Date>(16);

    //websocket连接池 usersiteid:(token:session)
    public static Map<Long, ConcurrentHashMap<String, WebSocket>> websocketClients = new ConcurrentHashMap<Long, ConcurrentHashMap<String, WebSocket>>();
    public static ArrayList<Long> websocketUserids = new ArrayList<>();

    /**
     * 用户授权系统表
     */
    public static HashMap<Long, Rows> userauth_systemids = new HashMap<>();

    /**
     * 用户授权系统模块表
     */
    public static HashMap<Long, Rows> userauth_systemmoduleids = new HashMap<>();
    /**
     * 用户授权系统应用表
     */
    public static HashMap<Long, Rows> userauth_systemappids = new HashMap<>();

    /**
     * 用户授权系统应用功能表
     */
    public static HashMap<Long, Rows> userauth_optionids = new HashMap<>();

    /**
     * 账号登陆时间，usersiteid，date
     */
    public static Map<Long, Date> loginDate = new HashMap<Long, Date>();

    /**
     * 接口访问间隔时长校验
     */
    public static Map<Method, Map<String, Long>> APIIntervaltimeCheck = new HashMap<>();

    /**
     * 方法请求次数
     */
    public static HashMap<String, Long> callmethodTimes = new HashMap<String, Long>(16);

    /**
     * 方法请求从缓存获取次数
     */
    public static HashMap<String, Long> callmethod_fromcacheTimes = new HashMap<String, Long>(16);

    /**
     * 方法请求查询平均时间
     */
    public static HashMap<String, Long> callmethodTimeLong = new HashMap<String, Long>(16);

    /**
     * 方法请求查询最新时间
     */
    public static HashMap<String, Long> callmethodLastTimeLong = new HashMap<String, Long>(16);

    /**
     * 方法请求最近时间
     */
    public static HashMap<String, Date> lastcallmethodtime = new HashMap<>(16);

}
